/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3DMatch;
import de.bioforscher.singa.chemistry.algorithms.superimposition.scores.PsScore;
import de.bioforscher.singa.chemistry.algorithms.superimposition.scores.XieScore;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Fit3D {
    public static final Logger logger = LoggerFactory.getLogger(Fit3D.class);

    public List<Fit3DMatch> getMatches();

    default public double getFraction() {
        throw new UnsupportedOperationException("Fraction of aligned residues is only available for the Fit3D site alignment algorithm and always 1.0 for Fit3D");
    }

    default public XieScore getXieScore() {
        throw new UnsupportedOperationException("Xie score only available for the Fit3D site alignment algorithm.");
    }

    default public PsScore getPsScore() {
        throw new UnsupportedOperationException("PS-score only available for the Fit3D site alignment algorithm.");
    }

    default public void writeMatches(Path outputDirectory, double rmsdCutoff) {
        this.getMatches().stream().filter(match -> match.getSubstructureSuperimposition() != null).filter(match -> match.getRmsd() <= rmsdCutoff).forEach(match -> {
            try {
                StructureWriter.writeLeafSubstructures(match.getSubstructureSuperimposition().getMappedFullCandidate(), outputDirectory.resolve(match.getSubstructureSuperimposition().getStringRepresentation() + ".pdb"));
            }
            catch (IOException e) {
                logger.error("could not write match {}", (Object)match.getSubstructureSuperimposition().getStringRepresentation(), (Object)e);
            }
        });
    }

    default public void writeMatches(Path outputDirectory) {
        this.getMatches().stream().filter(match -> match.getSubstructureSuperimposition() != null).forEach(match -> {
            try {
                StructureWriter.writeLeafSubstructures(match.getSubstructureSuperimposition().getMappedFullCandidate(), outputDirectory.resolve(match.getSubstructureSuperimposition().getStringRepresentation() + ".pdb"));
            }
            catch (IOException e) {
                logger.error("could not write match {}", (Object)match.getSubstructureSuperimposition().getStringRepresentation(), (Object)e);
            }
        });
    }

    default public void writeSummaryFile(Path summaryFilePath) throws IOException {
        String summaryFileContent = this.getMatches().stream().filter(match -> match.getSubstructureSuperimposition() != null).map(Fit3DMatch::toCsvLine).collect(Collectors.joining("\n", "match,rmsd,p-value\n", ""));
        Files.createDirectories(summaryFilePath.getParent(), new FileAttribute[0]);
        Files.write(summaryFilePath, summaryFileContent.getBytes(), new OpenOption[0]);
    }

    default public String getAlignmentString() {
        throw new UnsupportedOperationException("unique alignment string can only be obtained with Fit3DSite algorithm");
    }
}

