/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import java.util.StringJoiner;

public class Fit3DMatch
implements Comparable<Fit3DMatch> {
    public static final String CSV_HEADER = "match,rmsd,p-value\n";
    private SubstructureSuperimposition substructureSuperimposition;
    private double rmsd;
    private double pvalue;

    private Fit3DMatch(double rmsd, SubstructureSuperimposition substructureSuperimposition, double pvalue) {
        this.rmsd = rmsd;
        this.substructureSuperimposition = substructureSuperimposition;
        this.pvalue = pvalue;
    }

    public static Fit3DMatch of(double rmsd) {
        return new Fit3DMatch(rmsd, null, Double.NaN);
    }

    public static Fit3DMatch of(double rmsd, SubstructureSuperimposition substructureSuperimposition) {
        return new Fit3DMatch(rmsd, substructureSuperimposition, Double.NaN);
    }

    public static Fit3DMatch of(double rmsd, SubstructureSuperimposition substructureSuperimposition, double pvalue) {
        return new Fit3DMatch(rmsd, substructureSuperimposition, pvalue);
    }

    public String toString() {
        return "Fit3DMatch{substructureSuperimposition=" + this.substructureSuperimposition + ", rmsd=" + this.rmsd + ", pvalue=" + this.pvalue + '}';
    }

    public SubstructureSuperimposition getSubstructureSuperimposition() {
        return this.substructureSuperimposition;
    }

    public double getRmsd() {
        return this.rmsd;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public String toCsvLine() {
        StringJoiner stringJoiner = new StringJoiner(",");
        String stringRepresentation = this.substructureSuperimposition.getStringRepresentation();
        stringJoiner.add(stringRepresentation.replaceFirst("\\d+\\.\\d+_", ""));
        stringJoiner.add(String.valueOf(this.rmsd));
        stringJoiner.add(String.valueOf(this.pvalue));
        return stringJoiner.toString();
    }

    @Override
    public int compareTo(Fit3DMatch other) {
        return Double.compare(this.rmsd, other.rmsd);
    }
}

