/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d;

import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.core.utility.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidAlignmentGenerator {
    private static final Logger logger = LoggerFactory.getLogger(ValidAlignmentGenerator.class);
    private List<LeafSubstructure<?, ?>> reference;
    private List<LeafSubstructure<?, ?>> candidate;
    private List<List<LeafSubstructure<?, ?>>> pathsThroughSecondMotif;

    public ValidAlignmentGenerator(List<LeafSubstructure<?, ?>> reference, List<LeafSubstructure<?, ?>> candidate) {
        this.reference = reference;
        this.candidate = candidate;
    }

    public List<List<Pair<LeafSubstructure<?, ?>>>> getValidAlignments() {
        this.pathsThroughSecondMotif = new ArrayList();
        this.pathsThroughSecondMotif.add(new ArrayList());
        for (int currentPathLength = 0; currentPathLength < this.reference.size(); ++currentPathLength) {
            int expectedLength = currentPathLength + 1;
            LeafSubstructure<?, ?> currentReference = this.reference.get(currentPathLength);
            logger.trace("iteration {}: currently handling {} of reference motif", (Object)currentPathLength, currentReference);
            this.pathsThroughSecondMotif = this.candidate.stream().flatMap(candidateResidue -> this.pathsThroughSecondMotif.stream().map(this::cloneList).peek(path -> path.add(candidateResidue))).filter(path -> new HashSet(path).size() == expectedLength).filter(path -> {
                LeafSubstructure recentlyAddedResidue = (LeafSubstructure)path.get(path.size() - 1);
                Object recentlyAddedFamily = recentlyAddedResidue.getFamily();
                return recentlyAddedFamily.equals(currentReference.getFamily()) || currentReference.getExchangeableFamilies().contains(recentlyAddedFamily);
            }).collect(Collectors.toList());
        }
        return this.pathsThroughSecondMotif.stream().map(path -> IntStream.range(0, path.size()).mapToObj(index -> new Pair(this.reference.get(index), path.get(index))).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private List<LeafSubstructure<?, ?>> cloneList(List<LeafSubstructure<?, ?>> motif) {
        return motif.stream().map(Substructure::getCopy).collect(Collectors.toList());
    }
}

