/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.statistics;

import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.Fit3DMatch;
import de.bioforscher.singa.chemistry.algorithms.superimposition.fit3d.statistics.StatisticalModel;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.core.utility.Resources;
import de.bioforscher.singa.mathematics.vectors.RegularVector;
import de.bioforscher.singa.mathematics.vectors.Vector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FofanovEstimation
implements StatisticalModel {
    public static final int DEFAULT_REFERENCE_SIZE = 39592;
    private static final String BINARY_NAME = "Rscript";
    private static final double START_RMSD = 0.0;
    private static final double SAMPLE_SIZE = 10000.0;
    private static Logger logger = LoggerFactory.getLogger(FofanovEstimation.class);
    private int referenceSize = 39592;
    private double rmsdCutoff;
    private AtomicInteger gs;
    private AtomicInteger ns;
    private Path temporaryDirectoryPath;
    private Path scriptPath;
    private Path rmsdValuesPath;
    private Path pvaluesPath;
    private Vector pvalues;
    private List<Fit3DMatch> matches;
    private double modelCorrectnessCutoff;

    public FofanovEstimation(double rmsdCutoff) {
        this(rmsdCutoff, 39592, rmsdCutoff);
    }

    public FofanovEstimation(double rmsdCutoff, int referenceSize, double modelCorrectnessCutoff) {
        this.checkRequirements();
        this.rmsdCutoff = rmsdCutoff;
        this.referenceSize = referenceSize;
        this.modelCorrectnessCutoff = modelCorrectnessCutoff;
        this.gs = new AtomicInteger(0);
        this.ns = new AtomicInteger(0);
    }

    public static double determineEpsilon(StructuralMotif queryMotif, double modelCorrectnessCutoff) {
        int numberOfAtoms = queryMotif.getAllAtoms().size();
        return modelCorrectnessCutoff * Math.sqrt(numberOfAtoms);
    }

    public double getModelCorrectnessCutoff() {
        return this.modelCorrectnessCutoff;
    }

    private void checkRequirements() {
        try {
            Runtime.getRuntime().exec(BINARY_NAME);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("required binary Rscript must be installed to use the Fofanov statistical model");
        }
    }

    public void incrementNs() {
        this.ns.incrementAndGet();
    }

    public void incrementGs() {
        this.gs.incrementAndGet();
    }

    @Override
    public void calculatePvalues(List<Fit3DMatch> matches) throws IOException, InterruptedException {
        this.matches = matches;
        this.createTemporaryDirectory();
        this.writeRmsdValues();
        this.runScript();
        for (int i = 0; i < matches.size(); ++i) {
            Fit3DMatch match = matches.get(i);
            if (match.getRmsd() > this.modelCorrectnessCutoff) {
                match.setPvalue(Double.NaN);
                continue;
            }
            match.setPvalue(this.pvalues.getElement(i));
        }
    }

    private void writeRmsdValues() throws IOException {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern("0.0000");
        String formattedRmsdValues = this.matches.stream().map(Fit3DMatch::getRmsd).map(df::format).collect(Collectors.joining("\n", "rmsd\n", ""));
        Files.write(this.rmsdValuesPath, formattedRmsdValues.getBytes(), new OpenOption[0]);
        logger.info("rmsd values written to {}", (Object)this.rmsdValuesPath);
    }

    private void runScript() throws IOException, InterruptedException {
        logger.info("computing p-values by calling external R script");
        this.pvaluesPath = this.temporaryDirectoryPath.resolve("pvalues.csv");
        ProcessBuilder processBuilder = new ProcessBuilder(BINARY_NAME, this.scriptPath.toString(), String.valueOf(this.referenceSize), String.valueOf(this.ns.get()), String.valueOf(this.gs.get()), String.valueOf(0.0), String.valueOf(this.rmsdCutoff), String.valueOf(this.modelCorrectnessCutoff), String.valueOf(10000.0), this.rmsdValuesPath.toString(), this.pvaluesPath.toString());
        Process process = logger.isDebugEnabled() || logger.isInfoEnabled() ? processBuilder.inheritIO().start() : processBuilder.start();
        int exitStatus = process.waitFor();
        if (exitStatus != 0) {
            logger.error("p-value calculation failed");
            throw new RuntimeException("p-value calculation ended with exit status: " + exitStatus);
        }
        logger.info("p-value calculation successful");
        double[] pvalues = Files.readAllLines(this.pvaluesPath).stream().map(Double::valueOf).mapToDouble(Double::doubleValue).toArray();
        this.pvalues = new RegularVector(pvalues);
    }

    private void createTemporaryDirectory() throws IOException {
        this.temporaryDirectoryPath = Files.createTempDirectory("fit3d_", new FileAttribute[0]);
        this.rmsdValuesPath = this.temporaryDirectoryPath.resolve("rmsd.csv");
        InputStream resourceAsStream = Resources.getResourceAsStream((String)"de/bioforscher/singa/chemistry/algorithms/superimposition/fit3d/statistics/fofanov.R");
        this.scriptPath = this.temporaryDirectoryPath.resolve("fofanov.R");
        Files.copy(resourceAsStream, this.scriptPath, new CopyOption[0]);
        logger.debug("script fofanov.R copied to {}", (Object)this.scriptPath);
    }
}

