/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.annotations;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.chemistry.descriptive.annotations.AnnotationType;
import java.util.List;
import java.util.stream.Collectors;

public interface Annotatable {
    public List<Annotation> getAnnotations();

    default public void addAnnotation(Annotation annotation) {
        this.getAnnotations().add(annotation);
    }

    default public List<Annotation> getAnnotationsOfType(AnnotationType type) {
        return this.getAnnotations().stream().filter(annotation -> annotation.getAnnotationType() == type).collect(Collectors.toList());
    }

    default public <ContentType> List<ContentType> getContentOfAnnotations(Class<ContentType> expectedContent, AnnotationType type) {
        return this.getAnnotationsOfType(type).stream().map(Annotation::getContent).map(expectedContent::cast).collect(Collectors.toList());
    }

    default public <ContentType> List<ContentType> getContentOfAnnotations(Class<ContentType> expectedContent, String description, AnnotationType type) {
        return this.getAnnotationsOfType(type).stream().filter(annotation -> annotation.getDescription().equals(description)).map(Annotation::getContent).map(expectedContent::cast).collect(Collectors.toList());
    }

    default public <ContentType> ContentType getContentOfAnnotation(Class<ContentType> expectedContent, AnnotationType type) {
        return this.getContentOfAnnotations(expectedContent, type).get(0);
    }

    default public <ContentType> ContentType getContentOfAnnotation(Class<ContentType> expectedContent, String description, AnnotationType type) {
        return this.getContentOfAnnotations(expectedContent, description, type).get(0);
    }
}

