/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import de.bioforscher.singa.features.model.FeatureOrigin;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;

public class ComplexedChemicalEntity
extends ChemicalEntity<SimpleStringIdentifier> {
    private static final FeatureOrigin computedMassOrigin = new FeatureOrigin(FeatureOrigin.OriginType.PREDICTION, "Computed by the Sum of parts", "none");
    private Map<ChemicalEntity<?>, Integer> associatedParts = new HashMap();

    protected ComplexedChemicalEntity(SimpleStringIdentifier identifier) {
        super(identifier);
    }

    public void addAssociatedPart(ChemicalEntity chemicalEntity) {
        this.associatedParts.computeIfPresent(chemicalEntity, (key, value) -> value + 1);
        this.associatedParts.putIfAbsent(chemicalEntity, 1);
        this.computeMolarMass();
    }

    public Map<ChemicalEntity<?>, Integer> getAssociatedParts() {
        return this.associatedParts;
    }

    public Set<ChemicalEntity<?>> getAssociatedChemicalEntities() {
        return this.associatedParts.keySet();
    }

    private void computeMolarMass() {
        double sum = this.associatedParts.keySet().stream().mapToDouble(entity -> ((Quantity)entity.getFeature(MolarMass.class).getFeatureContent()).multiply((Number)this.associatedParts.get(entity)).getValue().doubleValue()).sum();
        this.setFeature(new MolarMass(sum, computedMassOrigin));
    }

    @Override
    public String toString() {
        return "ComplexedChemicalEntity " + super.getIdentifier() + " {associatedParts=" + this.associatedParts + '}';
    }

    public static class Builder
    extends ChemicalEntity.Builder<ComplexedChemicalEntity, Builder, SimpleStringIdentifier> {
        public Builder(SimpleStringIdentifier identifier) {
            super(identifier);
        }

        public Builder(String identifier) {
            this(new SimpleStringIdentifier(identifier));
        }

        @Override
        protected ComplexedChemicalEntity createObject(SimpleStringIdentifier primaryIdentifer) {
            return new ComplexedChemicalEntity(primaryIdentifer);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }

        public Builder addAssociatedPart(ChemicalEntity chemicalEntity) {
            if (chemicalEntity != null) {
                ((ComplexedChemicalEntity)this.topLevelObject).addAssociatedPart(chemicalEntity);
            }
            return this;
        }
    }
}

