/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Protein;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.MichaelisConstant;
import de.bioforscher.singa.chemistry.descriptive.features.reactions.TurnoverNumber;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import java.util.ArrayList;
import java.util.List;

public class Enzyme
extends Protein {
    private List<Species> substrates;

    protected Enzyme(SimpleStringIdentifier identifier) {
        super(identifier);
        this.availableFeatures.add(MichaelisConstant.class);
        this.availableFeatures.add(TurnoverNumber.class);
    }

    public List<Species> getSubstrates() {
        return this.substrates;
    }

    public void setSubstrates(List<Species> substrates) {
        this.substrates = substrates;
    }

    @Override
    public String toString() {
        return "Enzyme: " + this.getIdentifier() + " " + this.getName() + " weight: " + (Object)((Object)this.getFeature(MolarMass.class));
    }

    public static class Builder
    extends ChemicalEntity.Builder<Enzyme, Builder, SimpleStringIdentifier> {
        public Builder(SimpleStringIdentifier identifier) {
            super(identifier);
            ((Enzyme)this.topLevelObject).setSubstrates(new ArrayList<Species>());
        }

        public Builder(String identifier) {
            this(new SimpleStringIdentifier(identifier));
        }

        @Override
        protected Enzyme createObject(SimpleStringIdentifier primaryIdentifer) {
            return new Enzyme(primaryIdentifer);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }

        public Builder substrates(List<Species> substrates) {
            ((Enzyme)this.topLevelObject).setSubstrates(substrates);
            return this;
        }

        public Builder addSubstrate(Species substrate) {
            ((Enzyme)this.topLevelObject).getSubstrates().add(substrate);
            return this;
        }
    }
}

