/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.annotations.Annotation;
import de.bioforscher.singa.chemistry.descriptive.annotations.AnnotationType;
import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.core.biology.Organism;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import java.util.List;

public class Protein
extends ChemicalEntity<SimpleStringIdentifier> {
    protected Protein(SimpleStringIdentifier identifier) {
        super(identifier);
    }

    public void addOrganism(Organism organism) {
        this.addAnnotation(new Annotation<Organism>(AnnotationType.ORGANISM, organism));
    }

    public void addOrganism(Organism organism, String description) {
        this.addAnnotation(new Annotation<Organism>(AnnotationType.ORGANISM, description, organism));
    }

    public List<Organism> getAllOrganisms() {
        return this.getContentOfAnnotations(Organism.class, AnnotationType.ORGANISM);
    }

    public List<Organism> getOrganismsWith(String description) {
        return this.getContentOfAnnotations(Organism.class, description, AnnotationType.ORGANISM);
    }

    public void addAminoAcidSequence(String sequence) {
        this.addAnnotation(new Annotation<String>(AnnotationType.AMINO_ACID_SEQUENCE, sequence));
    }

    public List<String> getAllAminoAcidSequences() {
        return this.getContentOfAnnotations(String.class, AnnotationType.AMINO_ACID_SEQUENCE);
    }

    public List<String> getAllAminoAcidSequencesWith(String description) {
        return this.getContentOfAnnotations(String.class, description, AnnotationType.AMINO_ACID_SEQUENCE);
    }

    public static class Builder
    extends ChemicalEntity.Builder<Protein, Builder, SimpleStringIdentifier> {
        public Builder(SimpleStringIdentifier identifier) {
            super(identifier);
        }

        public Builder(String identifier) {
            this(new SimpleStringIdentifier(identifier));
        }

        @Override
        protected Protein createObject(SimpleStringIdentifier primaryIdentifer) {
            return new Protein(primaryIdentifer);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }
    }
}

