/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.entities;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.features.logp.LogP;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.chemistry.descriptive.features.smiles.Smiles;
import de.bioforscher.singa.core.identifier.SimpleStringIdentifier;
import de.bioforscher.singa.features.model.Feature;
import de.bioforscher.singa.features.model.FeatureOrigin;

public class Species
extends ChemicalEntity<SimpleStringIdentifier> {
    public static final Species UNKNOWN_SPECIES = (Species)((Builder)((Builder)new Builder("UNK").name("Unknown chemical species")).assignFeature((Feature)new MolarMass(10.0, FeatureOrigin.MANUALLY_ANNOTATED))).build();

    protected Species(SimpleStringIdentifier identifier) {
        super(identifier);
        this.availableFeatures.add(Smiles.class);
        this.availableFeatures.add(LogP.class);
    }

    protected Species(String identifier) {
        this(new SimpleStringIdentifier(identifier));
    }

    public static class Builder
    extends ChemicalEntity.Builder<Species, Builder, SimpleStringIdentifier> {
        public Builder(SimpleStringIdentifier identifier) {
            super(identifier);
        }

        public Builder(String identifier) {
            this(new SimpleStringIdentifier(identifier));
        }

        @Override
        protected Species createObject(SimpleStringIdentifier primaryIdentifer) {
            return new Species(primaryIdentifer);
        }

        @Override
        protected Builder getBuilder() {
            return this;
        }
    }
}

