/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.estimations;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.descriptive.features.smiles.SmilesParser;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeAtom;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBond;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBondType;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeGraph;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OctanolWaterPartition {
    private static final Logger logger = LoggerFactory.getLogger(OctanolWaterPartition.class);
    private static Map<FactorIdentifier, Double> parameterCoefficients = new HashMap<FactorIdentifier, Double>();
    private static LinkedList<Set<Element>> xyPath;
    private static LinkedList<Set<Element>> xayPath;
    private MoleculeGraph moleculeGraph;

    private static double getFactor(int equation, String parameter) {
        return parameterCoefficients.get(new FactorIdentifier(equation, parameter));
    }

    public OctanolWaterPartition(MoleculeGraph moleculeGraph) {
        this.moleculeGraph = moleculeGraph;
    }

    public static double calculateOctanolWaterPartitionCoefficient(MoleculeGraph moleculeGraph, Method method) {
        logger.info("calculating octanol/water partition coefficient using {}", (Object)method.toString());
        OctanolWaterPartition partition = new OctanolWaterPartition(moleculeGraph);
        switch (method) {
            case MLOGP_1: {
                return partition.calculateCoefficientUsingMLOGP1();
            }
            case MLOGP_2: {
                return partition.calculateCoefficientUsingMLOGP2();
            }
        }
        return partition.calculateCoefficientUsingNCAndNHET();
    }

    private double calculateCoefficientUsingNCAndNHET() {
        double carbons = this.calculateNumberOfCarbonAtoms();
        double nonCarbon = (double)this.moleculeGraph.getNodes().size() - carbons;
        logger.debug("number of hetero atoms is: {}", (Object)nonCarbon);
        double result = OctanolWaterPartition.getFactor(1, "NC_NC") * carbons + OctanolWaterPartition.getFactor(1, "NC_NHET") * nonCarbon + OctanolWaterPartition.getFactor(1, "NC_C");
        logger.debug("calculated log p using NC + NHET (Mannhold 2008): {}", (Object)result);
        return result;
    }

    private double calculateNumberOfCarbonAtoms() {
        double carbonAtoms = this.moleculeGraph.countAtomsOfElement(ElementProvider.CARBON);
        logger.debug("number of carbon atoms is: {}", (Object)carbonAtoms);
        return carbonAtoms;
    }

    private double calculateCoefficientUsingMLOGP1() {
        double result = OctanolWaterPartition.getFactor(1, "MLOGP_CX") * this.calculateCX() + OctanolWaterPartition.getFactor(1, "MLOGP_NO") * this.calcualteNO() + OctanolWaterPartition.getFactor(1, "MLOGP_C");
        logger.debug("calculated log p using MLOGP1 (Moriguchi 1992): {}", (Object)result);
        return result;
    }

    private double calculateCoefficientUsingMLOGP2() {
        double result = OctanolWaterPartition.getFactor(2, "MLOGP_CX") * Math.pow(this.calculateCX(), OctanolWaterPartition.getFactor(2, "MLOGP_ECX")) + OctanolWaterPartition.getFactor(2, "MLOGP_NO") * Math.pow(this.calcualteNO(), OctanolWaterPartition.getFactor(2, "MLOGP_ENO")) + OctanolWaterPartition.getFactor(2, "MLOGP_C");
        logger.debug("calculated log p using MLOGP2 Moriguchi 1992: {}", (Object)result);
        return result;
    }

    private double calculateCX() {
        double cx = 0.0;
        cx += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.CARBON);
        cx += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.FLUORINE) * 0.5;
        cx += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.CHLORINE);
        cx += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.BROMINE) * 1.5;
        logger.debug("CX parameter scored: {}", (Object)(cx += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.IODINE) * 2.0));
        return cx;
    }

    private double calcualteNO() {
        double no = 0.0;
        no += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.OXYGEN);
        logger.debug("NO parameter scored: {}", (Object)(no += (double)this.moleculeGraph.countAtomsOfElement(ElementProvider.NITROGEN)));
        return no;
    }

    private double calculatePRX() {
        double prx = 0.0;
        List<LinkedList<MoleculeAtom>> xy = this.moleculeGraph.findMultiPathOfElements(xyPath);
        prx += (double)xy.size();
        List<LinkedList<MoleculeAtom>> xay = this.moleculeGraph.findMultiPathOfElements(xayPath);
        for (LinkedList<MoleculeAtom> path : xay) {
            boolean isReduced = false;
            MoleculeAtom firstAtom = path.get(0);
            MoleculeAtom centralAtom = path.get(1);
            MoleculeAtom lastAtom = path.get(2);
            if (centralAtom.getElement().equals(ElementProvider.CARBON)) {
                if (firstAtom.getElement().equals(ElementProvider.OXYGEN)) {
                    if (lastAtom.getElement().equals(ElementProvider.NITROGEN) && ((MoleculeBond)((Object)this.moleculeGraph.getEdgeBetween((Node)centralAtom, (Node)firstAtom).get())).getType().equals((Object)MoleculeBondType.DOUBLE_BOND)) {
                        isReduced = true;
                    }
                } else if (lastAtom.getElement().equals(ElementProvider.OXYGEN) && ((MoleculeBond)((Object)this.moleculeGraph.getEdgeBetween((Node)centralAtom, (Node)lastAtom).get())).getType().equals((Object)MoleculeBondType.DOUBLE_BOND)) {
                    isReduced = true;
                }
            }
            if (isReduced) {
                logger.trace("{} scored: 1", path);
                prx += 1.0;
                continue;
            }
            logger.trace("{} scored: 2", path);
            prx += 2.0;
        }
        logger.debug("PRX parameter scored: {}", (Object)prx);
        return prx;
    }

    private double calculateUB() {
        double ub = 0.0;
        for (MoleculeBond bond : this.moleculeGraph.getEdges()) {
            long oxygenCount;
            if (bond.getType() != MoleculeBondType.DOUBLE_BOND && bond.getType() != MoleculeBondType.TRIPLE_BOND) continue;
            MoleculeAtom source = (MoleculeAtom)bond.getSource();
            MoleculeAtom target = (MoleculeAtom)bond.getTarget();
            boolean isIgnored = false;
            if (source.getElement().equals(ElementProvider.NITROGEN) && (oxygenCount = source.getNeighbours().stream().filter(moleculeAtom -> moleculeAtom.getElement().equals(ElementProvider.OXYGEN)).count()) == 2L) {
                isIgnored = true;
            }
            if (target.getElement().equals(ElementProvider.NITROGEN) && (oxygenCount = target.getNeighbours().stream().filter(moleculeAtom -> moleculeAtom.getElement().equals(ElementProvider.OXYGEN)).count()) == 2L) {
                isIgnored = true;
            }
            if (isIgnored) continue;
            ub += 1.0;
        }
        logger.debug("UB parameter scored: {}", (Object)ub);
        return ub;
    }

    public static void main(String[] args) {
        String ampicilin = "[H][C@]12SC(C)(C)[C@@H](N1C(=O)[C@H]2NC(=O)[C@H](N)c1ccccc1)C(O)=O";
        String valerolactone = "O=C1CCCCO1";
        String oxazepam = "OC1N=C(C2=CC=CC=C2)C2=C(NC1=O)C=CC(Cl)=C2";
        MoleculeGraph molecule = SmilesParser.parse(oxazepam);
        molecule.replaceAromaticsWithDoubleBonds();
        OctanolWaterPartition.calculateOctanolWaterPartitionCoefficient(molecule, Method.NC_NHET);
    }

    static {
        parameterCoefficients.put(new FactorIdentifier(1, "MLOGP_CX"), 0.246);
        parameterCoefficients.put(new FactorIdentifier(1, "MLOGP_NO"), -0.386);
        parameterCoefficients.put(new FactorIdentifier(1, "MLOGP_C"), 0.466);
        parameterCoefficients.put(new FactorIdentifier(2, "MLOGP_CX"), 1.001);
        parameterCoefficients.put(new FactorIdentifier(2, "MLOGP_ECX"), 0.6);
        parameterCoefficients.put(new FactorIdentifier(2, "MLOGP_NO"), -0.479);
        parameterCoefficients.put(new FactorIdentifier(2, "MLOGP_ENO"), 0.9);
        parameterCoefficients.put(new FactorIdentifier(2, "MLOGP_C"), 0.7554);
        parameterCoefficients.put(new FactorIdentifier(1, "NC_NC"), 0.11);
        parameterCoefficients.put(new FactorIdentifier(1, "NC_NHET"), -0.11);
        parameterCoefficients.put(new FactorIdentifier(1, "NC_C"), 1.46);
        xyPath = new LinkedList<HashSet>(Arrays.asList(new HashSet<Element>(Arrays.asList(ElementProvider.NITROGEN, ElementProvider.OXYGEN)), new HashSet<Element>(Arrays.asList(ElementProvider.NITROGEN, ElementProvider.OXYGEN))));
        xayPath = new LinkedList<HashSet>(Arrays.asList(new HashSet<Element>(Arrays.asList(ElementProvider.NITROGEN, ElementProvider.OXYGEN)), new HashSet<Element>(Arrays.asList(ElementProvider.CARBON, ElementProvider.SULFUR, ElementProvider.PHOSPHORUS)), new HashSet<Element>(Arrays.asList(ElementProvider.NITROGEN, ElementProvider.OXYGEN))));
    }

    private static class FactorIdentifier {
        private final int equation;
        private final String parameter;

        public FactorIdentifier(int equation, String parameter) {
            this.equation = equation;
            this.parameter = parameter;
        }

        public int getEquation() {
            return this.equation;
        }

        public String getParameter() {
            return this.parameter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FactorIdentifier that = (FactorIdentifier)o;
            if (this.equation != that.equation) {
                return false;
            }
            return this.parameter != null ? this.parameter.equals(that.parameter) : that.parameter == null;
        }

        public int hashCode() {
            int result = this.equation;
            result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
            return result;
        }
    }

    public static enum Method {
        MLOGP_1,
        MLOGP_2,
        NC_NHET;

    }
}

