/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem;

import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemContentHandler;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.databases.uniprot.UniProtParserService;
import de.bioforscher.singa.core.identifier.PubChemIdentifier;
import de.bioforscher.singa.core.parser.AbstractXMLParser;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PubChemParserService
extends AbstractXMLParser<Species> {
    private static final Logger logger = LoggerFactory.getLogger(UniProtParserService.class);
    private static final String PUBCHEM_FETCH_URL = "https://pubchem.ncbi.nlm.nih.gov/rest/pug_view/data/compound/%s/XML/";

    public PubChemParserService(PubChemIdentifier identifier) {
        this.getXmlReader().setContentHandler(new PubChemContentHandler());
        this.setResource(String.format(PUBCHEM_FETCH_URL, identifier.getConsecutiveNumber()));
    }

    public static Species parse(String pubChemIdentifier) {
        return PubChemParserService.parse(new PubChemIdentifier(pubChemIdentifier));
    }

    public static Species parse(PubChemIdentifier pubChemIdentifier) {
        logger.info("Parsing chemical entity with identifier " + pubChemIdentifier + " from " + PubChemDatabase.origin.getName());
        PubChemParserService parser = new PubChemParserService(pubChemIdentifier);
        return parser.parse();
    }

    public Species parse() {
        this.parseXML();
        return ((PubChemContentHandler)this.getXmlReader().getContentHandler()).getSpecies();
    }

    private void parseXML() {
        this.fetchResource();
        try {
            this.getXmlReader().parse(new InputSource(this.getFetchResult()));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not parse xml from fetch result, the server seems to be unavailable.", e);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }
}

