/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.diffusivity;

import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.DiffusivityProvider;
import de.bioforscher.singa.features.model.AbstractFeature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.FeatureRegistry;
import de.bioforscher.singa.features.model.ScalableFeature;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import tec.units.ri.quantity.Quantities;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.Units;

public class Diffusivity
extends AbstractFeature<Quantity<Diffusivity>>
implements Quantity<Diffusivity>,
ScalableFeature<Quantity<Diffusivity>> {
    public static final Unit<Diffusivity> SQUARE_CENTIMETER_PER_SECOND = new ProductUnit(Units.METRE.divide(100.0).pow(2).divide(Units.SECOND));
    private Quantity<Diffusivity> scaledQuantity;
    private Quantity<Diffusivity> halfScaledQuantity;

    public static void register() {
        FeatureRegistry.addProviderForFeature(Diffusivity.class, DiffusivityProvider.class);
    }

    public Diffusivity(Quantity<Diffusivity> diffusivityQuantity, FeatureOrigin origin) {
        super(diffusivityQuantity, origin);
    }

    public Diffusivity(double diffusivityQuantity, FeatureOrigin origin) {
        super((Object)Quantities.getQuantity((Number)diffusivityQuantity, SQUARE_CENTIMETER_PER_SECOND), origin);
    }

    public void scale(Quantity<Time> targetTimeScale, Quantity<Length> targetLengthScale) {
        Quantity scaledQuantity = ((Quantity)this.getFeatureContent()).to((Unit)new ProductUnit(targetLengthScale.getUnit().pow(2).divide(targetTimeScale.getUnit())));
        Quantity denominator = scaledQuantity.divide(targetLengthScale.getValue()).divide(targetLengthScale.getValue());
        this.scaledQuantity = denominator.multiply(targetTimeScale.getValue());
        this.halfScaledQuantity = denominator.multiply(targetTimeScale.multiply((Number)0.5).getValue());
    }

    public Quantity<Diffusivity> getScaledQuantity() {
        return this.scaledQuantity;
    }

    public Quantity<Diffusivity> getHalfScaledQuantity() {
        return this.halfScaledQuantity;
    }

    public Quantity<Diffusivity> add(Quantity<Diffusivity> augend) {
        return ((Quantity)this.getFeatureContent()).add(augend);
    }

    public Quantity<Diffusivity> subtract(Quantity<Diffusivity> subtrahend) {
        return ((Quantity)this.getFeatureContent()).subtract(subtrahend);
    }

    public Quantity<?> divide(Quantity<?> divisor) {
        return ((Quantity)this.getFeatureContent()).divide(divisor);
    }

    public Quantity<Diffusivity> divide(Number divisor) {
        return ((Quantity)this.getFeatureContent()).divide(divisor);
    }

    public Quantity<?> multiply(Quantity<?> multiplier) {
        return ((Quantity)this.getFeatureContent()).multiply(multiplier);
    }

    public Quantity<Diffusivity> multiply(Number multiplier) {
        return ((Quantity)this.getFeatureContent()).multiply(multiplier);
    }

    public Quantity<?> inverse() {
        return ((Quantity)this.getFeatureContent()).inverse();
    }

    public Quantity<Diffusivity> to(Unit<Diffusivity> unit) {
        return ((Quantity)this.getFeatureContent()).to(unit);
    }

    public <T extends Quantity<T>> Quantity<T> asType(Class<T> type) throws ClassCastException {
        return ((Quantity)this.getFeatureContent()).asType(type);
    }

    public Number getValue() {
        return ((Quantity)this.getFeatureContent()).getValue();
    }

    public Unit<Diffusivity> getUnit() {
        return ((Quantity)this.getFeatureContent()).getUnit();
    }
}

