/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.diffusivity;

import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.features.model.Correlation;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import tec.units.ri.AbstractUnit;
import tec.units.ri.quantity.Quantities;

public class WilkeCorrelation
implements Correlation<Diffusivity> {
    private static final FeatureOrigin origin = new FeatureOrigin(FeatureOrigin.OriginType.PREDICTION, "Wilke Correlation", "Wilke, C. R., and Pin Chang. \"Correlation of diffusion coefficients in dilute solutions.\" AIChE Journal 1.2 (1955): 264-270.");
    private static final Quantity<Dimensionless> WILKE_COEFFICIENT = Quantities.getQuantity((Number)7.4E-8, (Unit)AbstractUnit.ONE);
    private static final Quantity<Dimensionless> WILKE_ASSOCIATION_WATER = Quantities.getQuantity((Number)2.26, (Unit)AbstractUnit.ONE);

    public <FeaturableType extends Featureable> Diffusivity predict(FeaturableType featureable) {
        double molarMass = ((MolarMass)featureable.getFeature(MolarMass.class)).getValue().doubleValue();
        double dividend = WILKE_COEFFICIENT.getValue().doubleValue() * Math.pow(18.0153 * WILKE_ASSOCIATION_WATER.getValue().doubleValue(), 0.5) * EnvironmentalParameters.getInstance().getSystemTemperature().getValue().doubleValue();
        double divisor = EnvironmentalParameters.getInstance().getSystemViscosity().getValue().doubleValue() * Math.pow(WilkeCorrelation.estimateMolarVolume(molarMass), 0.6);
        Quantity quantity = Quantities.getQuantity((Number)(dividend / divisor), Diffusivity.SQUARE_CENTIMETER_PER_SECOND);
        return new Diffusivity((Quantity<Diffusivity>)quantity, origin);
    }

    private static double estimateMolarVolume(double molarMass) {
        return 0.968 * molarMass + 13.8;
    }
}

