/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.diffusivity;

import de.bioforscher.singa.chemistry.descriptive.features.diffusivity.Diffusivity;
import de.bioforscher.singa.chemistry.descriptive.features.molarmass.MolarMass;
import de.bioforscher.singa.features.model.Correlation;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.Featureable;
import de.bioforscher.singa.features.parameters.EnvironmentalParameters;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Dimensionless;
import tec.units.ri.AbstractUnit;
import tec.units.ri.quantity.Quantities;

public class YoungCorrelation
implements Correlation<Diffusivity> {
    private static final FeatureOrigin origin = new FeatureOrigin(FeatureOrigin.OriginType.PREDICTION, "Young Correlation", "Young, M. E., P. A. Carroad, and R. L. Bell. \"Estimation of diffusion coefficients of proteins.\" Biotechnology and Bioengineering 22.5 (1980): 947-955.");
    private static final Quantity<Dimensionless> YOUNG_COEFFICIENT = Quantities.getQuantity((Number)8.34E-8, (Unit)AbstractUnit.ONE);

    public <FeaturableType extends Featureable> Diffusivity predict(FeaturableType featureable) {
        double molarMass = ((MolarMass)featureable.getFeature(MolarMass.class)).getValue().doubleValue();
        double diffusivity = YOUNG_COEFFICIENT.getValue().doubleValue() * (EnvironmentalParameters.getInstance().getSystemTemperature().getValue().doubleValue() / (EnvironmentalParameters.getInstance().getSystemViscosity().getValue().doubleValue() * Math.cbrt(molarMass)));
        Quantity quantity = Quantities.getQuantity((Number)diffusivity, Diffusivity.SQUARE_CENTIMETER_PER_SECOND);
        return new Diffusivity((Quantity<Diffusivity>)quantity, origin);
    }
}

