/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.logp;

import de.bioforscher.singa.chemistry.descriptive.entities.ChemicalEntity;
import de.bioforscher.singa.chemistry.descriptive.entities.Species;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemDatabase;
import de.bioforscher.singa.chemistry.descriptive.features.databases.pubchem.PubChemParserService;
import de.bioforscher.singa.chemistry.descriptive.features.databases.unichem.UniChemParser;
import de.bioforscher.singa.chemistry.descriptive.features.logp.LogP;
import de.bioforscher.singa.core.identifier.InChIKey;
import de.bioforscher.singa.core.identifier.PubChemIdentifier;
import de.bioforscher.singa.core.identifier.model.Identifier;
import de.bioforscher.singa.features.model.FeatureProvider;
import de.bioforscher.singa.features.model.Featureable;
import java.util.List;
import java.util.Optional;

public class LogPProvider
extends FeatureProvider<LogP> {
    private final PubChemDatabase pubChemDatabase = PubChemDatabase.getInstance();

    public LogPProvider() {
        this.setProvidedFeature(LogP.class);
    }

    public <FeatureableType extends Featureable> LogP provide(FeatureableType featureable) {
        Optional inChiKey;
        ChemicalEntity species = (ChemicalEntity)featureable;
        Optional pubChemIdentifier = PubChemIdentifier.find(species.getAllIdentifiers());
        if (!pubChemIdentifier.isPresent() && (inChiKey = InChIKey.find(species.getAllIdentifiers())).isPresent()) {
            List<Identifier> identifiers = UniChemParser.parse((InChIKey)inChiKey.get());
            pubChemIdentifier = PubChemIdentifier.find(identifiers);
        }
        if (pubChemIdentifier.isPresent()) {
            Species logPSpecies = PubChemParserService.parse(((Identifier)pubChemIdentifier.get()).toString());
            return logPSpecies.getFeature(LogP.class);
        }
        return null;
    }
}

