/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.features.reactions;

import de.bioforscher.singa.features.model.AbstractFeature;
import de.bioforscher.singa.features.model.FeatureOrigin;
import de.bioforscher.singa.features.model.ScalableFeature;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import tec.units.ri.AbstractUnit;
import tec.units.ri.quantity.Quantities;
import tec.units.ri.unit.ProductUnit;
import tec.units.ri.unit.Units;

public class ForwardsRateConstant
extends AbstractFeature<Quantity<Frequency>>
implements ScalableFeature<Quantity<Frequency>> {
    private Quantity<Frequency> scaledQuantity;
    private Quantity<Frequency> halfScaledQuantity;

    public ForwardsRateConstant(Quantity<Frequency> frequencyQuantity, FeatureOrigin featureOrigin) {
        super(frequencyQuantity, featureOrigin);
    }

    public ForwardsRateConstant(double frequency, FeatureOrigin featureOrigin) {
        super((Object)Quantities.getQuantity((Number)frequency, (Unit)Units.HERTZ), featureOrigin);
    }

    public void scale(Quantity<Time> time, Quantity<Length> space) {
        Quantity scaledQuantity = ((Quantity)this.getFeatureContent()).to((Unit)new ProductUnit(AbstractUnit.ONE.divide(time.getUnit())));
        this.scaledQuantity = scaledQuantity.multiply((Number)time.getValue().doubleValue());
        this.halfScaledQuantity = scaledQuantity.multiply((Number)time.multiply((Number)0.5).getValue().doubleValue());
    }

    public Quantity<Frequency> getScaledQuantity() {
        return this.scaledQuantity;
    }

    public Quantity<Frequency> getHalfScaledQuantity() {
        return this.halfScaledQuantity;
    }
}

