/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.descriptive.molecules;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.descriptive.estimations.MoleculePathFinder;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeAtom;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBond;
import de.bioforscher.singa.chemistry.descriptive.molecules.MoleculeBondType;
import de.bioforscher.singa.mathematics.geometry.faces.Rectangle;
import de.bioforscher.singa.mathematics.graphs.model.AbstractGraph;
import de.bioforscher.singa.mathematics.graphs.model.Edge;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector2D;
import de.bioforscher.singa.mathematics.vectors.Vectors;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class MoleculeGraph
extends AbstractGraph<MoleculeAtom, MoleculeBond, Vector2D, Integer> {
    public static Predicate<MoleculeAtom> isElement(Element element) {
        return atom -> atom.getElement().getProtonNumber() == element.getProtonNumber();
    }

    public static Predicate<MoleculeAtom> isOneOfElements(Set<Element> elements) {
        return atom -> elements.contains(atom.getElement());
    }

    public int addNextAtom(char elementSymbol) {
        return this.addNextAtom(String.valueOf(elementSymbol));
    }

    public int addNextAtom(String elementSymbol) {
        return this.addNextAtom(ElementProvider.getElementBySymbol(elementSymbol).orElseThrow(() -> new IllegalArgumentException("The symbol " + elementSymbol + " represents no valid element.")));
    }

    public int addNextAtom(Element element) {
        MoleculeAtom atom = new MoleculeAtom(this.nextNodeIdentifier(), Vectors.generateRandom2DVector((Rectangle)new Rectangle(100.0, 100.0)), element);
        this.addNode((Node)atom);
        return (Integer)atom.getIdentifier();
    }

    public int addNextAtom(Element element, int charge) {
        Element ion = element.asIon(charge);
        return this.addNextAtom(ion);
    }

    public int addNextAtom(Element element, int charge, int massNumber) {
        Element modifiedElement = element.asIon(charge).asIsotope(massNumber);
        return this.addNextAtom(modifiedElement);
    }

    public int addEdgeBetween(int identifier, MoleculeAtom source, MoleculeAtom target) {
        return this.addEdgeBetween((Edge)new MoleculeBond(identifier), (Node)source, (Node)target);
    }

    public int addEdgeBetween(MoleculeAtom source, MoleculeAtom target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    public int addEdgeBetween(MoleculeAtom source, MoleculeAtom target, MoleculeBondType bondType) {
        MoleculeBond bond = new MoleculeBond(this.nextEdgeIdentifier());
        bond.setType(bondType);
        return this.addEdgeBetween((Edge)bond, (Node)source, (Node)target);
    }

    public Integer nextNodeIdentifier() {
        if (this.getNodes().isEmpty()) {
            return 0;
        }
        return this.getNodes().size();
    }

    public int countAtomsOfElement(Element element) {
        return (int)this.getNodes().stream().filter(MoleculeGraph.isElement(element)).count();
    }

    public List<LinkedList<MoleculeAtom>> findPathOfElements(LinkedList<Element> path) {
        return MoleculePathFinder.findPathInMolecule(this, path);
    }

    public List<LinkedList<MoleculeAtom>> findMultiPathOfElements(LinkedList<Set<Element>> path) {
        return MoleculePathFinder.findMultiPathInMolecule(this, path);
    }

    public void replaceAromaticsWithDoubleBonds() {
        List<LinkedList<MoleculeBond>> aromaticPaths = MoleculePathFinder.findAromaticPath(this);
        for (List list : aromaticPaths) {
            for (int i = 0; i < list.size(); ++i) {
                if (i % 2 == 0) {
                    ((MoleculeBond)((Object)list.get(i))).setType(MoleculeBondType.DOUBLE_BOND);
                    continue;
                }
                ((MoleculeBond)((Object)list.get(i))).setType(MoleculeBondType.SINGLE_BOND);
            }
        }
    }
}

