/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureCollector;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureContentIterator;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParserException;
import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureParserOptions;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.LeafSkeleton;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.core.utility.Pair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureParser {
    private static final Logger logger = LoggerFactory.getLogger(StructureParser.class);

    public static LocalSourceStep local() {
        return new SourceSelector();
    }

    public static IdentifierStep online() {
        return new SourceSelector();
    }

    public static class LocalPDB {
        static final Path BASE_PATH = Paths.get("data/structures/divided/pdb", new String[0]);
        private Path localPdbPath;

        public LocalPDB(String localPdbLocation) {
            this.localPdbPath = Paths.get(localPdbLocation, new String[0]);
        }

        public Path getLocalPdbPath() {
            return this.localPdbPath;
        }

        public Path getPathForPdbIdentifier(String pdbIdentifier) {
            pdbIdentifier = pdbIdentifier.toLowerCase();
            return this.localPdbPath.resolve(BASE_PATH).resolve(pdbIdentifier.substring(1, 3)).resolve(pdbIdentifier).resolve("pdb" + pdbIdentifier + ".ent.gz");
        }
    }

    static class SourceSelector
    implements LocalSourceStep,
    IdentifierStep,
    AdditionalLocalSourceStep {
        StructureContentIterator contentIterator;
        private LocalPDB localPDB;

        SourceSelector() {
        }

        @Override
        public SingleBranchStep pdbIdentifier(String pdbIdentifier) {
            this.contentIterator = new StructureContentIterator(pdbIdentifier);
            return new SingleReducingSelector(this);
        }

        @Override
        public MultiBranchStep pdbIdentifiers(List<String> pdbIdentifiers) {
            this.contentIterator = new StructureContentIterator(String.class, pdbIdentifiers);
            return new MultiReducingSelector(this);
        }

        @Override
        public SingleBranchStep file(File file) {
            this.contentIterator = new StructureContentIterator(file);
            return new SingleReducingSelector(this);
        }

        @Override
        public MultiBranchStep files(List<File> files) {
            this.contentIterator = new StructureContentIterator(File.class, files);
            return new MultiReducingSelector(this);
        }

        @Override
        public SingleBranchStep path(Path path) {
            this.contentIterator = new StructureContentIterator(path);
            return new SingleReducingSelector(this);
        }

        @Override
        public MultiBranchStep paths(List<Path> paths) {
            this.contentIterator = new StructureContentIterator(Path.class, paths);
            return new MultiReducingSelector(this);
        }

        @Override
        public SingleBranchStep inputStream(InputStream inputStream) {
            File tempFile;
            try {
                tempFile = File.createTempFile("temporaryStructure", ".pdb");
                Objects.requireNonNull(tempFile);
                tempFile.deleteOnExit();
                Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to parse structure from input stream.", e);
            }
            this.contentIterator = new StructureContentIterator(tempFile);
            return new SingleReducingSelector(this);
        }

        @Override
        public AdditionalLocalSourceStep localPDB(LocalPDB localPDB) {
            this.localPDB = localPDB;
            return this;
        }

        @Override
        public MultiBranchStep localPDB(LocalPDB localPDB, List<String> pdbIdentifiers) {
            this.contentIterator = new StructureContentIterator(localPDB, pdbIdentifiers);
            return new MultiReducingSelector(this);
        }

        @Override
        public SingleBranchStep localPDB(LocalPDB localPDB, String pdbIdentifier) {
            this.contentIterator = new StructureContentIterator(localPDB, pdbIdentifier);
            return new SingleReducingSelector(this);
        }

        @Override
        public SingleBranchStep fileLocation(String location) {
            this.contentIterator = new StructureContentIterator(Paths.get(location, new String[0]));
            return new SingleReducingSelector(this);
        }

        @Override
        public MultiBranchStep fileLocations(List<String> locations) {
            List paths = locations.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
            this.contentIterator = new StructureContentIterator(Path.class, paths);
            return new MultiReducingSelector(this);
        }

        @Override
        public MultiParser chainList(Path path, String separator) {
            try {
                this.contentIterator = this.localPDB != null ? new StructureContentIterator(this.readMappingFile(path, separator), this.localPDB) : new StructureContentIterator(this.readMappingFile(path, separator));
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not open input stream for chain list file.", e);
            }
            return new MultiReducingSelector(this).mapping();
        }

        @Override
        public MultiParser chainList(Path path) {
            return this.chainList(path, "\t");
        }

        /*
         * Exception decompiling
         */
        private List<Pair<String>> readMappingFile(Path mappingPath, String separator) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private List<Pair<String>> composePairsForChainList(List<String> lines, String separator) {
            ArrayList<Pair<String>> pairs = new ArrayList<Pair<String>>();
            for (String line : lines) {
                String[] split = line.split(separator);
                pairs.add((Pair<String>)new Pair((Object)split[0], (Object)split[1]));
            }
            return pairs;
        }
    }

    protected static class Reducer {
        SourceSelector sourceSelector;
        Map<String, LeafSkeleton> skeletons;
        String pdbIdentifier;
        int modelIdentifier;
        String chainIdentifier;
        boolean allModels = true;
        boolean allChains = true;
        boolean parseMapping = false;
        StructureParserOptions options = new StructureParserOptions();
        boolean modelsReduced;

        Reducer(SourceSelector sourceSelector) {
            this.sourceSelector = sourceSelector;
            this.skeletons = new HashMap<String, LeafSkeleton>();
        }

        void setModelIdentifier(int modelIdentifier) {
            this.modelIdentifier = modelIdentifier;
            this.modelsReduced = true;
            this.allModels = false;
        }

        void setChainIdentifier(String chainIdentifier) {
            Objects.requireNonNull(chainIdentifier);
            this.chainIdentifier = chainIdentifier;
            this.allChains = false;
            if (!this.modelsReduced) {
                this.allModels = true;
            }
        }

        void setAllChains() {
            this.allChains = true;
        }

        void setEverything() {
            if (!this.modelsReduced) {
                this.allModels = true;
            }
            this.allChains = true;
        }

        void updatePdbIdentifer() {
            this.pdbIdentifier = this.sourceSelector.contentIterator.getCurrentPdbIdentifier();
        }

        void updateChainIdentifier() {
            this.chainIdentifier = this.sourceSelector.contentIterator.getCurrentChainIdentifier();
        }

        public String toString() {
            return "Reducer{pdbIdentifier='" + this.pdbIdentifier + '\'' + ", modelIdentifier=" + this.modelIdentifier + ", chainIdentifier='" + this.chainIdentifier + '\'' + ", allModels=" + this.allModels + ", allChains=" + this.allChains + '}';
        }
    }

    static class SingleReducingSelector
    extends Reducer
    implements SingleBranchStep {
        SingleReducingSelector(SourceSelector sourceSelector) {
            super(sourceSelector);
        }

        @Override
        public SingleChainStep model(int modelIdentifier) {
            this.setModelIdentifier(modelIdentifier);
            return this;
        }

        @Override
        public SingleChainStep allModels() {
            this.allModels = true;
            return this;
        }

        @Override
        public SingleParser everything() {
            this.setEverything();
            return new SingleParser(this);
        }

        @Override
        public SingleParser chainIdentifier(String chainIdentifier) {
            this.setChainIdentifier(chainIdentifier);
            return new SingleParser(this);
        }

        @Override
        public SingleParser allChains() {
            this.setAllChains();
            return new SingleParser(this);
        }

        @Override
        public Structure parse() throws StructureParserException {
            this.setEverything();
            return new SingleParser(this).parse();
        }
    }

    static class MultiReducingSelector
    extends Reducer
    implements MultiBranchStep {
        MultiReducingSelector(SourceSelector sourceSelector) {
            super(sourceSelector);
        }

        @Override
        public MultiChainStep model(int modelIdentifier) {
            this.setModelIdentifier(modelIdentifier);
            return this;
        }

        @Override
        public MultiChainStep allModels() {
            this.allModels = true;
            return this;
        }

        @Override
        public MultiParser everything() {
            this.setEverything();
            return new MultiParser(this);
        }

        private MultiParser mapping() {
            this.parseMapping = true;
            return new MultiParser(this);
        }

        @Override
        public MultiParser chain(String chainIdentifier) {
            this.setChainIdentifier(chainIdentifier);
            return new MultiParser(this);
        }

        @Override
        public MultiParser allChains() {
            this.setAllChains();
            return new MultiParser(this);
        }

        @Override
        public List<Structure> parse() {
            this.setEverything();
            return new MultiParser(this).parse();
        }
    }

    public static class MultiParser
    implements Iterator<Structure> {
        MultiReducingSelector selector;

        MultiParser(MultiReducingSelector selector) {
            this.selector = selector;
        }

        public int getNumberOfQueuedStructures() {
            return this.selector.sourceSelector.contentIterator.getNumberOfQueuedStructures();
        }

        public int getNumberOfRemainingStructures() {
            return this.selector.sourceSelector.contentIterator.getNumberOfRemainingStructures();
        }

        public String getCurrentPdbIdentifier() {
            return this.selector.sourceSelector.contentIterator.getCurrentPdbIdentifier();
        }

        public String getCurrentChainIdentifier() {
            return this.selector.sourceSelector.contentIterator.getCurrentChainIdentifier();
        }

        public MultiParser setOptions(StructureParserOptions options) {
            this.selector.options = options;
            return this;
        }

        public List<Structure> parse() {
            logger.info("parsing {} structures ", (Object)this.getNumberOfQueuedStructures());
            ArrayList<Structure> structures = new ArrayList<Structure>();
            this.selector.sourceSelector.contentIterator.forEachRemaining(lines -> {
                try {
                    structures.add(StructureCollector.parse(lines, this.selector));
                }
                catch (StructureParserException | UncheckedIOException e) {
                    logger.warn("failed to parse structure", (Throwable)e);
                }
            });
            return structures;
        }

        @Override
        public synchronized boolean hasNext() {
            return this.selector.sourceSelector.contentIterator.hasNext();
        }

        @Override
        public synchronized Structure next() {
            return StructureCollector.parse((List<String>)this.selector.sourceSelector.contentIterator.next(), this.selector);
        }
    }

    public static class SingleParser {
        SingleReducingSelector selector;

        SingleParser(SingleReducingSelector selector) {
            this.selector = selector;
        }

        public SingleParser setOptions(StructureParserOptions options) {
            this.selector.options = options;
            return this;
        }

        public Structure parse() throws StructureParserException {
            return StructureCollector.parse((List<String>)this.selector.sourceSelector.contentIterator.next(), this.selector);
        }
    }

    public static interface SingleChainStep {
        public SingleParser chainIdentifier(String var1);

        public SingleParser allChains();

        public SingleParser everything();

        public Structure parse() throws StructureParserException;
    }

    public static interface MultiChainStep {
        public MultiParser chain(String var1);

        public MultiParser allChains();

        public MultiParser everything();

        public List<Structure> parse();
    }

    public static interface SingleBranchStep
    extends SingleChainStep {
        public SingleChainStep model(int var1);

        public SingleChainStep allModels();
    }

    public static interface MultiBranchStep
    extends MultiChainStep {
        public MultiChainStep model(int var1);

        public MultiChainStep allModels();
    }

    public static interface AdditionalLocalSourceStep {
        public MultiParser chainList(Path var1);

        public MultiParser chainList(Path var1, String var2);
    }

    public static interface LocalSourceStep {
        public SingleBranchStep file(File var1);

        public MultiBranchStep files(List<File> var1);

        public SingleBranchStep path(Path var1);

        public MultiBranchStep paths(List<Path> var1);

        public AdditionalLocalSourceStep localPDB(LocalPDB var1);

        public SingleBranchStep localPDB(LocalPDB var1, String var2);

        public MultiBranchStep localPDB(LocalPDB var1, List<String> var2);

        public SingleBranchStep fileLocation(String var1);

        public MultiBranchStep fileLocations(List<String> var1);

        public SingleBranchStep inputStream(InputStream var1);
    }

    public static interface IdentifierStep
    extends AdditionalLocalSourceStep {
        public SingleBranchStep pdbIdentifier(String var1);

        public MultiBranchStep pdbIdentifiers(List<String> var1);
    }
}

