/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.ChainTerminatorToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.HeaderToken;
import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.TitleToken;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralModel;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class StructureRepresentation {
    private final List<String> consecutiveRecords;
    private final String terminateRecord;
    private final List<LeafSubstructure<?, ?>> nonConsecutiveLeafs;

    private StructureRepresentation(Chain chain) {
        List<LeafSubstructure<?, ?>> consecutivePart = chain.getConsecutivePart();
        this.consecutiveRecords = this.getPdbLines(consecutivePart);
        this.terminateRecord = ChainTerminatorToken.assemblePDBLine(consecutivePart.get(consecutivePart.size() - 1));
        this.nonConsecutiveLeafs = chain.getNonConsecutivePart();
    }

    public static String composePdbRepresentation(Structure structure) {
        StringBuilder sb = new StringBuilder();
        sb.append(StructureRepresentation.getPreamble(structure.getPdbIdentifier(), structure.getTitle()));
        List<StructuralModel> allModels = structure.getAllModels();
        if (allModels.size() == 1) {
            StructuralModel structuralModel = allModels.iterator().next();
            StructureRepresentation.appendChainRepresentations(sb, structuralModel);
        } else {
            for (StructuralModel model : allModels) {
                sb.append("MODEL ").append(String.format("%5d", model.getIdentifier())).append(System.lineSeparator());
                StructureRepresentation.appendChainRepresentations(sb, model);
                sb.append("ENDMDL").append(System.lineSeparator());
            }
        }
        sb.append(StructureRepresentation.getPostamble());
        return sb.toString();
    }

    public static String composePdbRepresentation(List<LeafSubstructure<?, ?>> leaves) {
        StringBuilder sb = new StringBuilder();
        LeafSubstructure<?, ?> first = leaves.iterator().next();
        sb.append(StructureRepresentation.getPreamble(first.getPdbIdentifier(), ""));
        sb.append(StructureRepresentation.composePdbRepresentationOfNonConsecutiveRecords(leaves));
        sb.append(StructureRepresentation.getPostamble());
        return sb.toString();
    }

    private static void appendChainRepresentations(StringBuilder sb, StructuralModel structuralModel) {
        List chainRepresentations = structuralModel.getAllChains().stream().map(StructureRepresentation::new).collect(Collectors.toList());
        ArrayList nonConsecutiveRecords = new ArrayList();
        for (StructureRepresentation chainRepresentation : chainRepresentations) {
            sb.append(chainRepresentation.getConsecutiveRepresentation()).append(chainRepresentation.getTerminateRecord());
            nonConsecutiveRecords.addAll(chainRepresentation.getNonConsecutiveLeafSubstructures());
        }
        sb.append(StructureRepresentation.composePdbRepresentationOfNonConsecutiveRecords(nonConsecutiveRecords));
    }

    public static String composePdbRepresentation(StructuralModel structuralModel) {
        List chainRepresentations = structuralModel.getAllChains().stream().map(StructureRepresentation::new).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList nonConsecutiveRecords = new ArrayList();
        for (StructureRepresentation chainRepresentation : chainRepresentations) {
            stringBuilder.append(chainRepresentation.getConsecutiveRepresentation()).append(chainRepresentation.getTerminateRecord());
            nonConsecutiveRecords.addAll(chainRepresentation.getNonConsecutiveLeafSubstructures());
        }
        stringBuilder.append(StructureRepresentation.composePdbRepresentationOfNonConsecutiveRecords(nonConsecutiveRecords));
        return stringBuilder.toString();
    }

    private static String composePdbRepresentationOfNonConsecutiveRecords(List<LeafSubstructure<?, ?>> nonConsecutiveLeafs) {
        if (!nonConsecutiveLeafs.isEmpty()) {
            nonConsecutiveLeafs.sort(Comparator.comparingInt(nonConsecutiveLeaf -> (Integer)nonConsecutiveLeaf.getAllAtoms().get(0).getIdentifier()));
            return nonConsecutiveLeafs.stream().map(LeafSubstructure::getPdbLines).flatMap(Collection::stream).collect(Collectors.joining(System.lineSeparator(), "", System.lineSeparator()));
        }
        return "";
    }

    private List<String> getPdbLines(Collection<LeafSubstructure<?, ?>> leafSubstructures) {
        return leafSubstructures.stream().map(LeafSubstructure::getPdbLines).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String getConsecutiveRepresentation() {
        return this.consecutiveRecords.stream().collect(Collectors.joining(System.lineSeparator(), "", System.lineSeparator()));
    }

    private String getTerminateRecord() {
        return this.terminateRecord + System.lineSeparator();
    }

    private List<LeafSubstructure<?, ?>> getNonConsecutiveLeafSubstructures() {
        return this.nonConsecutiveLeafs;
    }

    private static String getPreamble(String pdbIdentifier, String title) {
        StringBuilder sb = new StringBuilder();
        if (pdbIdentifier != null && !pdbIdentifier.equals("0000")) {
            sb.append(HeaderToken.assemblePDBLine(pdbIdentifier));
            sb.append(System.lineSeparator());
        }
        if (title != null && !title.isEmpty()) {
            for (String titleLine : TitleToken.assemblePDBLines(title)) {
                sb.append(titleLine);
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    private static String getPostamble() {
        return "END" + System.lineSeparator() + System.lineSeparator();
    }
}

