/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.pdb.structures;

import de.bioforscher.singa.chemistry.parser.pdb.structures.StructureRepresentation;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureWriter {
    private static final Logger logger = LoggerFactory.getLogger(StructureWriter.class);

    private StructureWriter() {
    }

    public static void writeBranchSubstructure(BranchSubstructure<?, ?> branchSubstructure, Path outputPath) throws IOException {
        logger.info("Writing branch substructure {} to {}.", branchSubstructure, (Object)outputPath);
        StructureWriter.writeLeafSubstructures(branchSubstructure.getLeafSubstructures(), outputPath);
    }

    public static void writeLeafSubstructures(List<LeafSubstructure<?, ?>> leafSubstructures, Path outputPath) throws IOException {
        logger.info("Writing {} leaf substructures to {}.", (Object)leafSubstructures.size(), (Object)outputPath);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.write(outputPath, StructureRepresentation.composePdbRepresentation(leafSubstructures).getBytes(), new OpenOption[0]);
    }

    public static void writeStructure(Structure structure, Path outputPath) throws IOException {
        logger.info("Writing structure {} to {}.", (Object)structure, (Object)outputPath);
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        Files.write(outputPath, StructureRepresentation.composePdbRepresentation(structure).getBytes(), new OpenOption[0]);
    }
}

