/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.plip;

import de.bioforscher.singa.chemistry.parser.plip.HalogenBond;
import de.bioforscher.singa.chemistry.parser.plip.HydrogenBond;
import de.bioforscher.singa.chemistry.parser.plip.HydrophobicInteraction;
import de.bioforscher.singa.chemistry.parser.plip.Interaction;
import de.bioforscher.singa.chemistry.parser.plip.InteractionContainer;
import de.bioforscher.singa.chemistry.parser.plip.InteractionType;
import de.bioforscher.singa.chemistry.parser.plip.MetalComplex;
import de.bioforscher.singa.chemistry.parser.plip.PiCation;
import de.bioforscher.singa.chemistry.parser.plip.PiStacking;
import de.bioforscher.singa.chemistry.parser.plip.SaltBridge;
import de.bioforscher.singa.chemistry.parser.plip.WaterBridge;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class PlipContentHandler
implements ContentHandler {
    private static final Logger logger = LoggerFactory.getLogger(InteractionContainer.class);
    private InteractionContainer interactions = new InteractionContainer();
    private String currentTag;
    private String currentPdbIdentifier = "0000";
    private String firstLeafSerial;
    private String secondLeafSerial;
    private String firstLeafChain;
    private String secondLeafChain;
    private boolean ligcoo;
    private double c1x;
    private double c1y;
    private double c1z;
    private double c2x;
    private double c2y;
    private double c2z;
    private boolean noResidueInteraction;
    private InteractionType interactionType;
    private Interaction currentInteraction;

    public PlipContentHandler(String pdbIdentifier) {
        this.currentPdbIdentifier = pdbIdentifier;
    }

    public String getCurrentPdbIdentifier() {
        return this.currentPdbIdentifier;
    }

    public void setCurrentPdbIdentifier(String currentPdbIdentifier) {
        this.currentPdbIdentifier = currentPdbIdentifier;
    }

    public InteractionContainer getInteractionContainer() {
        return this.interactions;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.currentTag = qName;
        switch (qName) {
            case "halogen_bond": {
                this.currentInteraction = new HalogenBond(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.HALOGEN_BOND;
                break;
            }
            case "hydrophobic_interaction": {
                this.currentInteraction = new HydrophobicInteraction(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.HYDROPHOBIC_INTERACTION;
                break;
            }
            case "hydrogen_bond": {
                this.currentInteraction = new HydrogenBond(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.HYDROGEN_BOND;
                break;
            }
            case "water_bridge": {
                this.currentInteraction = new WaterBridge(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.WATER_BRIDGE;
                break;
            }
            case "salt_bridge": {
                this.currentInteraction = new SaltBridge(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.SALT_BRIDGE;
                break;
            }
            case "pi_stack": {
                this.currentInteraction = new PiStacking(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.PI_STACKING;
                break;
            }
            case "pi_cation_interaction": {
                this.currentInteraction = new PiCation(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.PI_CATION_INTERACTION;
                break;
            }
            case "metal_complex": {
                this.currentInteraction = new MetalComplex(Integer.valueOf(atts.getValue("id")));
                this.interactionType = InteractionType.METAL_COMPLEX;
                break;
            }
            case "ligcoo": {
                this.ligcoo = true;
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentTag = "";
        switch (qName) {
            case "halogen_bond": 
            case "hydrophobic_interaction": 
            case "hydrogen_bond": 
            case "water_bridge": 
            case "salt_bridge": 
            case "pi_stack": 
            case "pi_cation_interaction": 
            case "metal_complex": {
                this.addInteraction();
                break;
            }
            case "ligcoo": {
                this.ligcoo = false;
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        block41 : switch (this.currentTag) {
            case "resnr": {
                this.firstLeafSerial = new String(ch, start, length);
                break;
            }
            case "resnr_lig": {
                this.secondLeafSerial = new String(ch, start, length);
                break;
            }
            case "reschain": {
                this.firstLeafChain = new String(ch, start, length);
                break;
            }
            case "reschain_lig": {
                this.secondLeafChain = new String(ch, start, length);
                break;
            }
            case "x": {
                if (this.ligcoo) {
                    this.c1x = this.asDouble(ch, start, length);
                    break;
                }
                this.c2x = this.asDouble(ch, start, length);
                break;
            }
            case "y": {
                if (this.ligcoo) {
                    this.c1y = this.asDouble(ch, start, length);
                    break;
                }
                this.c2y = this.asDouble(ch, start, length);
                break;
            }
            case "z": {
                if (this.ligcoo) {
                    this.c1z = this.asDouble(ch, start, length);
                    break;
                }
                this.c2z = this.asDouble(ch, start, length);
                break;
            }
            case "dist": {
                switch (this.interactionType) {
                    case HALOGEN_BOND: {
                        this.as(HalogenBond.class).setDistance(this.asDouble(ch, start, length));
                        break;
                    }
                    case METAL_COMPLEX: {
                        this.as(MetalComplex.class).setDistance(this.asDouble(ch, start, length));
                        break;
                    }
                    case HYDROPHOBIC_INTERACTION: {
                        this.as(HydrophobicInteraction.class).setDistance(this.asDouble(ch, start, length));
                        break;
                    }
                    case PI_CATION_INTERACTION: {
                        this.as(PiCation.class).setDistance(this.asDouble(ch, start, length));
                        break;
                    }
                    case PI_STACKING: {
                        this.as(PiStacking.class).setDistance(this.asDouble(ch, start, length));
                        break;
                    }
                    case SALT_BRIDGE: {
                        this.as(SaltBridge.class).setDistance(this.asDouble(ch, start, length));
                    }
                }
                break;
            }
            case "dist_a-w": {
                this.as(WaterBridge.class).setDistanceAW(this.asDouble(ch, start, length));
                break;
            }
            case "dist_d-w": {
                this.as(WaterBridge.class).setDistanceDW(this.asDouble(ch, start, length));
                break;
            }
            case "don_angle": {
                switch (this.interactionType) {
                    case WATER_BRIDGE: {
                        this.as(WaterBridge.class).setDonorAngle(this.asDouble(ch, start, length));
                        break;
                    }
                    case HYDROGEN_BOND: {
                        this.as(HydrogenBond.class).setAngle(this.asDouble(ch, start, length));
                        break;
                    }
                    case HALOGEN_BOND: {
                        this.as(HalogenBond.class).setDonorAngle(this.asDouble(ch, start, length));
                    }
                }
                break;
            }
            case "water_angle": {
                this.as(WaterBridge.class).setWaterAngle(this.asDouble(ch, start, length));
                break;
            }
            case "donor_idx": {
                this.as(WaterBridge.class).setDonor(this.asInteger(ch, start, length));
                break;
            }
            case "acceptor_idx": {
                this.as(WaterBridge.class).setAcceptor(this.asInteger(ch, start, length));
                break;
            }
            case "sidechain": {
                switch (this.interactionType) {
                    case HYDROGEN_BOND: {
                        this.as(HydrogenBond.class).setSidechain(this.asBoolean(ch, start, length));
                        break block41;
                    }
                }
                break;
            }
            case "protisdon": {
                switch (this.interactionType) {
                    case HYDROGEN_BOND: {
                        this.as(HydrogenBond.class).setProtIsDon(this.asBoolean(ch, start, length));
                        break;
                    }
                    case WATER_BRIDGE: {
                        this.as(WaterBridge.class).setProtIsDon(this.asBoolean(ch, start, length));
                    }
                }
                break;
            }
            case "dist_h-a": {
                this.as(HydrogenBond.class).setDistanceHA(this.asDouble(ch, start, length));
                break;
            }
            case "dist_d-a": {
                this.as(HydrogenBond.class).setDistanceDA(this.asDouble(ch, start, length));
                break;
            }
            case "donoridx": {
                this.as(HydrogenBond.class).setDonor(this.asInteger(ch, start, length));
                break;
            }
            case "acceptoridx": {
                this.as(HydrogenBond.class).setAcceptor(this.asInteger(ch, start, length));
                break;
            }
            case "metal_idx": {
                this.as(MetalComplex.class).setAtom1(this.asInteger(ch, start, length));
                break;
            }
            case "target_idx": {
                this.as(MetalComplex.class).setAtom2(this.asInteger(ch, start, length));
                break;
            }
            case "metal_type": {
                this.as(MetalComplex.class).setMetalType(new String(ch, start, length));
                break;
            }
            case "location": {
                this.as(MetalComplex.class).setLocation(new String(ch, start, length));
                break;
            }
            case "geometry": {
                this.as(MetalComplex.class).setGeometry(new String(ch, start, length));
                break;
            }
            case "complexnum": {
                this.as(MetalComplex.class).setComplexnum(this.asInteger(ch, start, length));
                break;
            }
            case "acc_angle": {
                this.as(HalogenBond.class).setAcceptorAngle(this.asDouble(ch, start, length));
                break;
            }
            case "don_idx": {
                this.as(HalogenBond.class).setDonor(this.asInteger(ch, start, length));
                break;
            }
            case "acc_idx": {
                this.as(HalogenBond.class).setAcceptor(this.asInteger(ch, start, length));
                break;
            }
            case "idx": {
                switch (this.interactionType) {
                    case PI_CATION_INTERACTION: {
                        this.as(PiCation.class).getAtoms2().add(this.asInteger(ch, start, length));
                        break;
                    }
                    case PI_STACKING: {
                        this.as(PiStacking.class).getAtoms2().add(this.asInteger(ch, start, length));
                        break;
                    }
                    case SALT_BRIDGE: {
                        this.as(SaltBridge.class).getAtoms2().add(this.asInteger(ch, start, length));
                    }
                }
                break;
            }
            case "protispos": {
                this.as(SaltBridge.class).setProtIsPos(this.asBoolean(ch, start, length));
                break;
            }
            case "angle": {
                this.as(PiStacking.class).setAngle(this.asDouble(ch, start, length));
                break;
            }
            case "offset": {
                switch (this.interactionType) {
                    case PI_CATION_INTERACTION: {
                        this.as(PiCation.class).setOffset(this.asDouble(ch, start, length));
                        break;
                    }
                    case PI_STACKING: {
                        this.as(PiStacking.class).setOffset(this.asDouble(ch, start, length));
                    }
                }
                break;
            }
            case "type": {
                this.as(PiStacking.class).setType(new String(ch, start, length));
                break;
            }
            case "protcharged": {
                this.as(PiCation.class).setProtcharged(this.asBoolean(ch, start, length));
                break;
            }
            case "lig_group": {
                switch (this.interactionType) {
                    case PI_CATION_INTERACTION: {
                        this.as(PiCation.class).setLigandGroup(new String(ch, start, length));
                        break;
                    }
                    case SALT_BRIDGE: {
                        this.as(SaltBridge.class).setLigandGroup(new String(ch, start, length));
                    }
                }
                break;
            }
            case "protcarbonidx": {
                this.as(HydrophobicInteraction.class).setAtom1(this.asInteger(ch, start, length));
                break;
            }
            case "ligcarbonidx": {
                this.as(HydrophobicInteraction.class).setAtom2(this.asInteger(ch, start, length));
                break;
            }
            case "restype_lig": {
                String restype = new String(ch, start, length);
                if (AminoAcidFamily.getAminoAcidTypeByThreeLetterCode(restype).isPresent()) break;
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private <InteractionClass extends Interaction> InteractionClass as(Class<InteractionClass> interactionType) {
        return (InteractionClass)((Interaction)interactionType.cast(this.currentInteraction));
    }

    private void addInteraction() {
        if (this.noResidueInteraction) {
            this.noResidueInteraction = false;
            return;
        }
        if (this.firstLeafSerial.length() > 9 || this.firstLeafSerial.equals("NA")) {
            logger.debug("The leaf serial {} is not valid. Skipping this interaction.", (Object)this.firstLeafSerial);
            return;
        }
        if (this.secondLeafSerial.length() > 9 || this.secondLeafSerial.equals("NA")) {
            logger.debug("The leaf serial {} is not valid. Skipping this interaction.", (Object)this.firstLeafSerial);
            return;
        }
        LeafIdentifier source = new LeafIdentifier(this.currentPdbIdentifier, 0, this.firstLeafChain, Integer.valueOf(this.firstLeafSerial));
        LeafIdentifier target = new LeafIdentifier(this.currentPdbIdentifier, 0, this.secondLeafChain, Integer.valueOf(this.secondLeafSerial));
        this.currentInteraction.setSource(source);
        this.currentInteraction.setTarget(target);
        this.currentInteraction.setLigandCoordinate(new double[]{this.c1x, this.c1y, this.c1z});
        this.currentInteraction.setProteinCoordinate(new double[]{this.c2x, this.c2y, this.c2z});
        this.interactions.addInteraction(this.currentInteraction);
    }

    private double asDouble(char[] ch, int start, int length) {
        return Double.valueOf(new String(ch, start, length));
    }

    private int asInteger(char[] ch, int start, int length) {
        return Integer.valueOf(new String(ch, start, length));
    }

    private boolean asBoolean(char[] ch, int start, int length) {
        return Boolean.valueOf(new String(ch, start, length));
    }
}

