/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.parser.plip;

import de.bioforscher.singa.chemistry.parser.plip.Interaction;
import de.bioforscher.singa.chemistry.parser.plip.InteractionContainer;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.mathematics.algorithms.graphs.NeighbourhoodExtractor;
import de.bioforscher.singa.mathematics.graphs.model.GenericGraph;
import de.bioforscher.singa.mathematics.graphs.model.GenericNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class PlipShellGenerator {
    private final Chain chain;
    private final LeafSubstructure<?, ?> reference;
    private final InteractionContainer interChainInteractions;
    private final InteractionContainer referenceInteractions;
    private final Map<InteractionShell, List<LeafSubstructure<?, ?>>> shells;
    private GenericGraph<LeafSubstructure<?, ?>> graph;

    private PlipShellGenerator(Chain chain, LeafSubstructure<?, ?> reference, InteractionContainer interChainInteractions, InteractionContainer referenceInteractions) {
        this.chain = chain;
        this.reference = reference;
        this.interChainInteractions = interChainInteractions;
        this.referenceInteractions = referenceInteractions;
        this.shells = new TreeMap();
        this.graph = new GenericGraph();
        this.generateInteractionGraph();
        this.computeShells();
    }

    public static PlipShellGenerator getInteractionShellsForLigand(Chain chain, LeafSubstructure<?, ?> reference, InteractionContainer interChainInteractions, InteractionContainer referenceInteractions) {
        return new PlipShellGenerator(chain, reference, interChainInteractions, referenceInteractions);
    }

    private void computeShells() {
        GenericNode referenceNode = (GenericNode)this.graph.getNodeWithContent(this.reference).orElseThrow(() -> new IllegalArgumentException("No such reference node in interaction graph."));
        for (InteractionShell interactionShell : InteractionShell.values()) {
            this.shells.put(interactionShell, interactionShell.from(this.graph, referenceNode));
        }
    }

    public Map<InteractionShell, List<LeafSubstructure<?, ?>>> getShells() {
        return this.shells;
    }

    private void generateInteractionGraph() {
        Set firstShell = this.referenceInteractions.getInteractions().stream().filter(interaction -> interaction.getTarget().equals(this.reference.getIdentifier())).map(Interaction::getSource).map(leafIdentifier -> this.chain.getLeafSubstructures().stream().filter(leafSubstructure -> leafSubstructure.getIdentifier().equals(leafIdentifier)).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        this.graph.addNode(this.reference);
        for (LeafSubstructure leafSubstructure : firstShell) {
            this.graph.addNode((Object)leafSubstructure);
            this.graph.addEdgeBetween(this.reference, (Object)leafSubstructure);
        }
        for (Interaction interaction2 : this.interChainInteractions.getInteractions()) {
            LeafSubstructure<?, ?> source = this.chain.getLeafSubstructure(interaction2.getSource());
            LeafSubstructure<?, ?> target = this.chain.getLeafSubstructure(interaction2.getTarget());
            this.graph.addEdgeBetween(source, target);
        }
    }

    public GenericGraph<LeafSubstructure<?, ?>> getGraph() {
        return this.graph;
    }

    public static enum InteractionShell {
        FIRST,
        SECOND,
        THIRD;


        public List<LeafSubstructure<?, ?>> from(GenericGraph<LeafSubstructure<?, ?>> graph, GenericNode<LeafSubstructure<?, ?>> referenceNode) {
            return NeighbourhoodExtractor.extractShell(graph, referenceNode, (int)(this.ordinal() + 1)).stream().map(GenericNode::getContent).collect(Collectors.toList());
        }
    }
}

