/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms;

import de.bioforscher.singa.chemistry.descriptive.elements.Element;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.ArrayList;
import java.util.List;

public class RegularAtom
implements Atom {
    private int identifier;
    private Element element;
    private String atomNameString;
    private Vector3D position;
    private List<Atom> neighbours;

    public RegularAtom(int identifier, Element element, String atomNameString, Vector3D position) {
        this.atomNameString = atomNameString;
        this.identifier = identifier;
        this.element = element;
        this.position = position;
        this.neighbours = new ArrayList<Atom>();
    }

    public RegularAtom(Atom atom) {
        this.atomNameString = atom.getAtomNameString();
        this.identifier = (Integer)atom.getIdentifier();
        this.element = atom.getElement();
        this.position = new Vector3D((Vector3D)atom.getPosition());
        this.neighbours = new ArrayList<Atom>();
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    public Integer getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public Vector3D getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3D position) {
        this.position = position;
    }

    public void addNeighbour(Atom node) {
        if (this.equals(node)) {
            throw new IllegalArgumentException("Can not establish self reference between two identical atoms.");
        }
        this.neighbours.add(node);
    }

    public List<Atom> getNeighbours() {
        return this.neighbours;
    }

    public int getDegree() {
        return this.neighbours.size();
    }

    @Override
    public String getAtomNameString() {
        return this.atomNameString;
    }

    @Override
    public void setAtomNameString(String atomNameString) {
        this.atomNameString = atomNameString;
    }

    public Atom getCopy() {
        return new RegularAtom(this);
    }

    public String toString() {
        return "Atom: " + this.atomNameString + " " + this.identifier + " (" + this.position.getX() + ", " + this.position.getY() + ", " + this.position.getZ() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegularAtom that = (RegularAtom)o;
        if (this.identifier != that.identifier) {
            return false;
        }
        if (this.atomNameString != null ? !this.atomNameString.equals(that.atomNameString) : that.atomNameString != null) {
            return false;
        }
        return this.position != null ? this.position.equals((Object)that.position) : that.position == null;
    }

    public int hashCode() {
        int result = this.identifier;
        result = 31 * result + (this.atomNameString != null ? this.atomNameString.hashCode() : 0);
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        return result;
    }
}

