/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms.representations;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.atoms.UncertainAtom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BetaCarbonRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?, ?> leafSubstructure) {
        if (leafSubstructure.containsAtomWithName(AtomName.CB)) {
            return leafSubstructure.getAtomByName(AtomName.CB);
        }
        if (!(leafSubstructure instanceof AminoAcid)) {
            logger.warn("fallback for {} because it is no amino acid", leafSubstructure);
            return this.determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getFamily() == AminoAcidFamily.GLYCINE) {
            AminoAcid alanine = AminoAcidFamily.ALANINE.getPrototype();
            SubstructureSuperimposition superimposition = SubstructureSuperimposer.calculateIdealSubstructureSuperimposition(Stream.of(leafSubstructure).collect(Collectors.toList()), Stream.of(alanine).collect(Collectors.toList()), StructuralEntityFilter.AtomFilter.isBackbone());
            Optional<Atom> optionalBetaCarbon = superimposition.getMappedFullCandidate().get(0).getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isBetaCarbon()).findAny();
            if (optionalBetaCarbon.isPresent()) {
                return new UncertainAtom((Integer)leafSubstructure.getAllAtoms().get(0).getIdentifier(), ElementProvider.CARBON, RepresentationSchemeType.CB.getAtomNameString(), (Vector3D)((Vector3D)optionalBetaCarbon.get().getPosition()).getCopy());
            }
        }
        return (Atom)leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isBetaCarbon()).findAny().orElseGet(() -> this.determineCentroid(leafSubstructure)).getCopy();
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.CB;
    }
}

