/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.atoms.representations;

import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.atoms.UncertainAtom;
import de.bioforscher.singa.chemistry.physical.atoms.representations.AbstractRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.BetaCarbonRepresentationScheme;
import de.bioforscher.singa.chemistry.physical.atoms.representations.RepresentationSchemeType;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.List;
import java.util.stream.Collectors;

public class SideChainCentroidRepresentationScheme
extends AbstractRepresentationScheme {
    @Override
    public Atom determineRepresentingAtom(LeafSubstructure<?, ?> leafSubstructure) {
        if (leafSubstructure.containsAtomWithName(AtomName.SC)) {
            return leafSubstructure.getAtomByName(AtomName.SC);
        }
        if (!(leafSubstructure instanceof AminoAcid)) {
            return this.determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getFamily() == AminoAcidFamily.GLYCINE) {
            return new BetaCarbonRepresentationScheme().determineCentroid(leafSubstructure);
        }
        if (leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isSideChain()).count() == 0L) {
            return this.determineCentroid(leafSubstructure);
        }
        List atomPositions = leafSubstructure.getAllAtoms().stream().filter(StructuralEntityFilter.AtomFilter.isSideChain().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate())).map(Node::getPosition).collect(Collectors.toList());
        return new UncertainAtom((Integer)leafSubstructure.getAllAtoms().get(0).getIdentifier(), ElementProvider.UNKOWN, RepresentationSchemeType.SIDE_CHAIN_CENTROID.getAtomNameString(), Vectors3D.getCentroid(atomPositions));
    }

    @Override
    public RepresentationSchemeType getType() {
        return RepresentationSchemeType.SIDE_CHAIN_CENTROID;
    }
}

