/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralModel;
import de.bioforscher.singa.chemistry.physical.interactions.Bond;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class BranchSubstructure<SubstructureType extends Substructure<SubstructureType, IdentifierType>, IdentifierType>
implements Substructure<SubstructureType, IdentifierType> {
    protected IdentifierType identifier;
    protected Map<Object, Substructure<?, ?>> substructures;
    private LeafIdentifier nextLeafIdentifier;
    private int nextEdgeIdentifier;
    private List<SubstructureType> neighbours;
    private Map<Integer, Bond> edges;

    public BranchSubstructure(IdentifierType identifier) {
        this.identifier = identifier;
        this.neighbours = new ArrayList<SubstructureType>();
        this.substructures = new TreeMap();
        this.edges = new HashMap<Integer, Bond>();
    }

    public BranchSubstructure(BranchSubstructure<SubstructureType, IdentifierType> branchSubstructure) {
        this.identifier = branchSubstructure.getIdentifier();
        this.substructures = new TreeMap();
        for (Substructure<?, ?> structure : branchSubstructure.substructures.values()) {
            this.substructures.put(structure.getIdentifier(), (Substructure<?, ?>)structure.getCopy());
        }
        this.edges = new HashMap<Integer, Bond>();
        for (Bond bond : branchSubstructure.edges.values()) {
            Bond edgeCopy = bond.getCopy();
            Atom sourceCopy = branchSubstructure.getNode((Integer)((Atom)bond.getSource()).getIdentifier());
            Atom targetCopy = branchSubstructure.getNode((Integer)((Atom)bond.getTarget()).getIdentifier());
            this.addEdgeBetween(edgeCopy, sourceCopy, targetCopy);
        }
        this.neighbours = new ArrayList<SubstructureType>();
    }

    public IdentifierType getIdentifier() {
        return this.identifier;
    }

    public Vector3D getPosition() {
        return Vectors3D.getCentroid((Collection)this.getAllAtoms().stream().map(Node::getPosition).collect(Collectors.toList()));
    }

    public void setPosition(Vector3D position) {
        this.getAllAtoms().forEach(atom -> atom.setPosition(((Vector3D)atom.getPosition()).add(position)));
    }

    public void addNeighbour(SubstructureType substructure) {
        if (this.equals(substructure)) {
            throw new IllegalArgumentException("Can not establish self reference between two identical substructures.");
        }
        this.neighbours.add(substructure);
    }

    public List<SubstructureType> getNeighbours() {
        return this.neighbours;
    }

    public int getDegree() {
        return this.neighbours.size();
    }

    public List<Atom> getNodes() {
        return this.getAllAtoms();
    }

    public Atom getNode(Integer identifier) {
        return this.getBranchSubstructures().stream().flatMap(branchSubstructure -> branchSubstructure.getAllAtoms().stream()).filter(atom -> ((Integer)atom.getIdentifier()).equals(identifier)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not get atom with identifier " + identifier + "."));
    }

    public Integer addNode(Atom atom) {
        throw new UnsupportedOperationException("BranchSubstructures only contains atoms in leaf substructures. If you want to add a atom, add it to any of the leafs of this branch.");
    }

    public void addAllNodes(Collection<Atom> atoms) {
        throw new UnsupportedOperationException("BranchSubstructures only contains atoms in leaf substructures. If you want to add a atom, add it to any of the leafs of this branch.");
    }

    public void addSubstructure(Substructure substructure) {
        this.substructures.put(substructure.getIdentifier(), substructure);
    }

    public <RemovableSubstructureType extends Substructure> void removeSubstructure(RemovableSubstructureType substructure) {
        this.removeSubstructure(substructure.getIdentifier());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeSubstructure(Object identifier) {
        if (identifier instanceof LeafIdentifier && this instanceof StructuralModel) {
            LeafIdentifier leafIdentifier = (LeafIdentifier)identifier;
            Optional<Chain> chainWithLeaf = this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isChain()).map(Chain.class::cast).filter(chain -> ((String)chain.getIdentifier()).equals(leafIdentifier.getChainIdentifier())).findFirst();
            if (!chainWithLeaf.isPresent()) throw new IllegalArgumentException("Tried to remove substructure with identifier" + identifier.toString() + ", but was unable to retrieve it.");
            chainWithLeaf.get().removeSubstructure(leafIdentifier);
            return;
        } else {
            List<Integer> atomsToBeRemoved = this.substructures.get(identifier).getAllAtoms().stream().map(Node::getIdentifier).collect(Collectors.toList());
            atomsToBeRemoved.forEach(this::removeNode);
            this.substructures.remove(identifier);
        }
    }

    public List<Substructure<?, ?>> getSubstructures() {
        return new ArrayList(this.substructures.values());
    }

    public List<BranchSubstructure<?, ?>> getBranchSubstructures() {
        ArrayList branchSubStructures = new ArrayList();
        for (Substructure<?, ?> substructure : this.substructures.values()) {
            if (!(substructure instanceof BranchSubstructure)) continue;
            BranchSubstructure branchSubstructure = (BranchSubstructure)substructure;
            branchSubStructures.add(branchSubstructure);
            branchSubStructures.addAll(branchSubstructure.getBranchSubstructures());
        }
        return branchSubStructures;
    }

    public List<LeafSubstructure<?, ?>> getLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        for (Substructure<?, ?> substructure : this.substructures.values()) {
            if (substructure instanceof LeafSubstructure) {
                leafSubstructures.add((LeafSubstructure)substructure);
                continue;
            }
            if (!(substructure instanceof BranchSubstructure)) continue;
            leafSubstructures.addAll(((BranchSubstructure)substructure).getLeafSubstructures());
        }
        return leafSubstructures;
    }

    public List<AminoAcid> getAminoAcids() {
        return this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).collect(Collectors.toList());
    }

    public List<Nucleotide> getNucleotides() {
        return this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).collect(Collectors.toList());
    }

    public Optional<Substructure> getSubstructure(int identifier) {
        return Optional.ofNullable(this.substructures.getOrDefault(identifier, null));
    }

    public void addAllSubstructures(List<Substructure> substructures) {
        substructures.forEach(substructure -> this.substructures.put(substructure.getIdentifier(), (Substructure<?, ?>)substructure));
    }

    public Atom removeNode(Atom atom) {
        return this.removeNode((Integer)atom.getIdentifier());
    }

    public Atom removeNode(Integer identifier) {
        LeafSubstructure leafWithAtom = this.getLeafSubstructures().stream().filter(leafSubstructure -> leafSubstructure.getNodes().stream().anyMatch(atom -> ((Integer)atom.getIdentifier()).equals(identifier))).findAny().orElseThrow(() -> new IllegalArgumentException("Could not remove atom with identifier " + identifier + ",No leaf found that contains any atom with this identifier."));
        return leafWithAtom.removeNode(identifier);
    }

    public int nextEdgeIdentifier() {
        return this.nextEdgeIdentifier++;
    }

    public Set<Bond> getEdges() {
        return new HashSet<Bond>(this.edges.values());
    }

    public Bond getEdge(int identifier) {
        return this.edges.get(identifier);
    }

    public int addEdgeBetween(int identifier, Atom source, Atom target) {
        return this.addEdgeBetween(new Bond(identifier), source, target);
    }

    public int addEdgeBetween(Bond edge, Atom source, Atom target) {
        edge.setSource(source);
        edge.setTarget(target);
        this.edges.put(edge.getIdentifier(), edge);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return edge.getIdentifier();
    }

    public int addEdgeBetween(Atom source, Atom target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    @Override
    public List<Atom> getAllAtoms() {
        ArrayList<Atom> atoms = new ArrayList<Atom>();
        for (Substructure<?, ?> substructure : this.substructures.values()) {
            atoms.addAll(substructure.getAllAtoms());
        }
        return atoms;
    }

    public LeafIdentifier getNextLeafIdentifier() {
        LeafIdentifier last = this.nextLeafIdentifier == null ? this.getLeafSubstructures().stream().map(LeafSubstructure::getIdentifier).max(LeafIdentifier::compareTo).orElseThrow(() -> new IllegalStateException("Could not find any largest leaf identifier, possibly this structure does not contain any elements.")) : this.nextLeafIdentifier;
        this.nextLeafIdentifier = new LeafIdentifier(last.getPdbIdentifier(), last.getModelIdentifier(), last.getChainIdentifier(), last.getSerial() + 1);
        return this.nextLeafIdentifier;
    }

    public boolean containsNode(Object node) {
        return this.getAllAtoms().contains(node);
    }

    public boolean containsEdge(Object edge) {
        return this.edges.containsValue(edge);
    }

    @Override
    public abstract SubstructureType getCopy();

    public Integer nextNodeIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String flatToString() {
        return this.getClass().getSimpleName() + " " + this.identifier + ": " + this.getSubstructures().stream().map(branch -> branch.getClass().getSimpleName() + " " + branch.getIdentifier()).collect(Collectors.joining(", "));
    }

    @Override
    public String deepToString() {
        return this.getClass().getSimpleName() + " " + this.identifier + " with Branches: {" + this.getSubstructures().stream().map(Substructure::flatToString).collect(Collectors.joining(", ")) + "}";
    }

    public String toString() {
        return this.flatToString();
    }
}

