/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.interactions.Bond;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class Chain
extends BranchSubstructure<Chain, String> {
    private Set<LeafIdentifier> consecutiveIdentifiers;

    public Chain(String identifier) {
        super(identifier);
        this.consecutiveIdentifiers = new TreeSet<LeafIdentifier>();
    }

    public Chain(Chain chain) {
        this((String)chain.getIdentifier());
        for (Substructure<?, ?> structure : chain.getSubstructures()) {
            this.addSubstructure((Substructure)structure.getCopy());
        }
        TreeMap<Object, Atom> atoms = new TreeMap<Object, Atom>();
        for (Atom atom : this.getAllAtoms()) {
            atoms.put(atom.getIdentifier(), atom);
        }
        for (Bond bond : chain.getEdges()) {
            Bond edgeCopy = bond.getCopy();
            Atom sourceCopy = (Atom)atoms.get(((Atom)bond.getSource()).getIdentifier());
            Atom targetCopy = (Atom)atoms.get(((Atom)bond.getTarget()).getIdentifier());
            this.addEdgeBetween(edgeCopy, sourceCopy, targetCopy);
        }
    }

    public Chain() {
        super("X");
    }

    public void connectChainBackbone() {
        LeafSubstructure<?, ?> lastSubstructure = null;
        for (LeafSubstructure<?, ?> currentSubstructure : this.getLeafSubstructures()) {
            if (lastSubstructure != null) {
                if (lastSubstructure instanceof AminoAcid && currentSubstructure instanceof AminoAcid) {
                    this.connectPeptideBonds((AminoAcid)lastSubstructure, (AminoAcid)currentSubstructure);
                } else if (lastSubstructure instanceof Nucleotide && currentSubstructure instanceof Nucleotide) {
                    this.connectNucleotideBonds((Nucleotide)lastSubstructure, (Nucleotide)currentSubstructure);
                }
            }
            lastSubstructure = currentSubstructure;
        }
    }

    public void connectPeptideBonds(AminoAcid source, AminoAcid target) {
        Bond bond = new Bond(this.nextEdgeIdentifier());
        if (source.containsAtomWithName(AtomName.C) && target.containsAtomWithName(AtomName.N)) {
            this.addEdgeBetween(bond, source.getBackboneCarbon(), target.getBackboneNitrogen());
        }
    }

    public void connectNucleotideBonds(Nucleotide source, Nucleotide target) {
        Bond bond = new Bond(this.nextEdgeIdentifier());
        if (source.containsAtomWithName(AtomName.O3Pr) && target.containsAtomWithName(AtomName.P)) {
            this.addEdgeBetween(bond, source.getAtomByName(AtomName.O3Pr), target.getAtomByName(AtomName.P));
        }
    }

    public void addToConsecutivePart(LeafSubstructure<?, ?> leafSubstructure) {
        this.consecutiveIdentifiers.add(leafSubstructure.getIdentifier());
        this.addSubstructure(leafSubstructure);
    }

    public List<LeafSubstructure<?, ?>> getConsecutivePart() {
        return this.consecutiveIdentifiers.stream().map(this::getLeafSubstructure).collect(Collectors.toList());
    }

    public List<LeafSubstructure<?, ?>> getNonConsecutivePart() {
        return this.getLeafSubstructures().stream().filter(leafSubstructure -> !this.consecutiveIdentifiers.contains(leafSubstructure.getIdentifier())).map(substructure -> substructure).collect(Collectors.toList());
    }

    @Override
    public List<LeafSubstructure<?, ?>> getLeafSubstructures() {
        return this.substructures.values().stream().map(substructure -> (LeafSubstructure)substructure).collect(Collectors.toList());
    }

    public LeafSubstructure<?, ?> getLeafSubstructure(LeafIdentifier identifier) {
        return (LeafSubstructure)this.substructures.get(identifier);
    }

    @Override
    public String flatToString() {
        return "Chain " + (String)this.identifier + " containing " + this.getSubstructures().size() + " LeafSubstructures";
    }

    @Override
    public String deepToString() {
        return "Chain " + (String)this.identifier + ", with Leaves: {" + this.getLeafSubstructures().stream().map(leaf -> leaf.getFamily().getThreeLetterCode() + "-" + leaf.getIdentifier().getSerial()).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public Chain getCopy() {
        return new Chain(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chain that = (Chain)o;
        return this.identifier != null ? ((String)this.identifier).equals(that.identifier) : that.identifier == null;
    }

    public int hashCode() {
        return this.identifier != null ? ((String)this.identifier).hashCode() : 0;
    }
}

