/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.families.MatcherFamily;
import de.bioforscher.singa.chemistry.physical.families.NucleotideFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class StructuralMotif
extends BranchSubstructure<StructuralMotif, String> {
    public LinkedHashMap<Object, Substructure<?, ?>> orderedSubstructures = new LinkedHashMap();

    private StructuralMotif(String identifier) {
        super(identifier);
    }

    private StructuralMotif(String identifier, List<LeafSubstructure<?, ?>> leafSubstructures) {
        this(identifier);
        leafSubstructures.forEach(this::addSubstructure);
    }

    private StructuralMotif(StructuralMotif structuralMotif) {
        super(structuralMotif);
        for (LeafSubstructure<?, ?> leafSubstructure : structuralMotif.getOrderedLeafSubstructures()) {
            this.orderedSubstructures.put(leafSubstructure.getIdentifier(), this.getSubstructures().get(this.getSubstructures().indexOf(leafSubstructure)));
        }
    }

    public static StructuralMotif fromLeafIdentifiers(Structure structure, List<LeafIdentifier> leafIdentifiers) {
        ArrayList leaves = new ArrayList();
        leafIdentifiers.forEach(leafIdentifer -> {
            LeafSubstructure subStructure = structure.getAllLeafSubstructures().stream().filter(leaf -> leaf.getChainIdentifier().equals(leafIdentifer.getChainIdentifier()) && leaf.getIdentifier().getSerial() == leafIdentifer.getSerial()).findFirst().orElseThrow(NoSuchElementException::new);
            leaves.add(subStructure);
        });
        return new StructuralMotif(StructuralMotif.generateMotifIdentifier(leaves), leaves);
    }

    public static StructuralMotif fromLeafSubstructures(List<LeafSubstructure<?, ?>> leafSubstructures) {
        return new StructuralMotif(StructuralMotif.generateMotifIdentifier(leafSubstructures), leafSubstructures);
    }

    private static String generateMotifIdentifier(List<LeafSubstructure<?, ?>> substructures) {
        String pdbIdentifier = substructures.iterator().next().getPdbIdentifier();
        return substructures.stream().map(leafSubstructure -> leafSubstructure.getChainIdentifier() + "-" + leafSubstructure.getIdentifier().getSerial()).collect(Collectors.joining("_", pdbIdentifier + "_", ""));
    }

    @Override
    public <RemovableSubstructureType extends Substructure> void removeSubstructure(RemovableSubstructureType substructure) {
        super.removeSubstructure(substructure);
        this.orderedSubstructures.remove(substructure.getIdentifier());
    }

    public List<LeafSubstructure<?, ?>> getOrderedLeafSubstructures() {
        ArrayList leafSubstructures = new ArrayList();
        for (Substructure<?, ?> substructure : this.orderedSubstructures.values()) {
            if (substructure instanceof LeafSubstructure) {
                leafSubstructures.add((LeafSubstructure)substructure);
                continue;
            }
            if (!(substructure instanceof BranchSubstructure)) continue;
            leafSubstructures.addAll(((BranchSubstructure)substructure).getLeafSubstructures());
        }
        return leafSubstructures;
    }

    @Override
    public void addSubstructure(Substructure substructure) {
        this.substructures.put(substructure.getIdentifier(), substructure);
        this.orderedSubstructures.put(substructure.getIdentifier(), substructure);
    }

    @Override
    public String toString() {
        return StructuralMotif.generateMotifIdentifier(this.getLeafSubstructures());
    }

    public int size() {
        return this.getLeafSubstructures().size();
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, MatcherFamily matcherFamily) {
        matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafIdentifier, (AminoAcidFamily)matcherFamilyMember));
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, NucleotideFamily nucleotideFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).filter(nucleotide -> nucleotide.getIdentifier().getChainIdentifier().equals(leafIdentifier.getChainIdentifier()) && nucleotide.getIdentifier().getSerial() == leafIdentifier.getSerial()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(nucleotideFamily);
    }

    public void addExchangeableFamily(LeafIdentifier leafIdentifier, AminoAcidFamily aminoAcidFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).filter(aminoAcid -> aminoAcid.getIdentifier().getChainIdentifier().equals(leafIdentifier.getChainIdentifier())).filter(aminoAcid -> aminoAcid.getIdentifier().getSerial() == leafIdentifier.getSerial()).findFirst().orElseThrow(NoSuchElementException::new).addExchangeableFamily(aminoAcidFamily);
    }

    public void addExchangeableFamilyToAll(AminoAcidFamily aminoAcidFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isAminoAcid()).map(AminoAcid.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(aminoAcidFamily));
    }

    public void addExchangeableFamilyToAll(NucleotideFamily nucleotideFamily) {
        this.getLeafSubstructures().stream().filter(StructuralEntityFilter.LeafFilter.isNucleotide()).map(Nucleotide.class::cast).forEach(exchangeable -> exchangeable.addExchangeableFamily(nucleotideFamily));
    }

    public void addExchangeableFamilyToAll(MatcherFamily matcherFamily) {
        this.getLeafSubstructures().forEach(leafSubstructure -> matcherFamily.getMembers().forEach(matcherFamilyMember -> this.addExchangeableFamily(leafSubstructure.getIdentifier(), (AminoAcidFamily)matcherFamilyMember)));
    }

    @Override
    public StructuralMotif getCopy() {
        return new StructuralMotif(this);
    }
}

