/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.branches;

import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposer;
import de.bioforscher.singa.chemistry.algorithms.superimposition.SubstructureSuperimposition;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.families.MatcherFamily;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;

public class StructuralMotifs {
    private StructuralMotifs() {
    }

    public static void assignComplexExchanges(StructuralMotif structuralMotif, EnumSet<MatcherFamily> familyGroup) {
        for (LeafSubstructure<?, ?> leafSubstructure : structuralMotif.getLeafSubstructures()) {
            familyGroup.stream().filter(family -> family.getMembers().contains(leafSubstructure.getFamily())).forEach(familyMember -> structuralMotif.addExchangeableFamily(leafSubstructure.getIdentifier(), (MatcherFamily)familyMember));
        }
    }

    public static LabeledSymmetricMatrix<StructuralMotif> calculateRmsdMatrix(List<StructuralMotif> structuralMotifs, boolean idealSuperimposition) {
        return StructuralMotifs.calculateRmsdMatrix(structuralMotifs, StructuralEntityFilter.AtomFilter.isArbitrary(), idealSuperimposition);
    }

    public static LabeledSymmetricMatrix<StructuralMotif> calculateRmsdMatrix(List<StructuralMotif> structuralMotifs, Predicate<Atom> atomFilter, boolean idealSuperimposition) {
        if (structuralMotifs.stream().map(StructuralMotif::size).distinct().count() != 1L) {
            throw new IllegalArgumentException("RMSD matrix can only be calculated for structural motifs of same size");
        }
        double[][] temporaryDistanceMatrix = new double[structuralMotifs.size()][structuralMotifs.size()];
        ArrayList<StructuralMotif> matrixLabels = new ArrayList<StructuralMotif>();
        matrixLabels.add(structuralMotifs.get(0));
        for (int i = 0; i < structuralMotifs.size() - 1; ++i) {
            for (int j = i + 1; j < structuralMotifs.size(); ++j) {
                StructuralMotif reference = structuralMotifs.get(i);
                StructuralMotif candidate = structuralMotifs.get(j);
                SubstructureSuperimposition superimposition = idealSuperimposition ? SubstructureSuperimposer.calculateIdealSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)candidate, atomFilter) : SubstructureSuperimposer.calculateSubstructureSuperimposition((BranchSubstructure)reference, (BranchSubstructure)candidate, atomFilter);
                temporaryDistanceMatrix[i][j] = superimposition.getRmsd();
                temporaryDistanceMatrix[j][i] = superimposition.getRmsd();
            }
            matrixLabels.add(structuralMotifs.get(i + 1));
        }
        LabeledSymmetricMatrix rmsdMatrix = new LabeledSymmetricMatrix(temporaryDistanceMatrix);
        rmsdMatrix.setColumnLabels(matrixLabels);
        return rmsdMatrix;
    }
}

