/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.leaves;

import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.families.AminoAcidFamily;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;

public class AminoAcid
extends LeafSubstructure<AminoAcid, AminoAcidFamily> {
    private final boolean modified;
    private final String modifiedName;

    public AminoAcid(LeafIdentifier leafIdentifier, AminoAcidFamily family) {
        super(leafIdentifier, family);
        this.modified = false;
        this.modifiedName = null;
    }

    public AminoAcid(int leafsSerial, AminoAcidFamily family) {
        this(new LeafIdentifier(leafsSerial), family);
    }

    public AminoAcid(LeafIdentifier leafIdentifier, AminoAcidFamily family, String modifiedName) {
        super(leafIdentifier, family);
        this.modified = true;
        this.modifiedName = modifiedName;
    }

    public AminoAcid(AminoAcid aminoAcid) {
        super(aminoAcid);
        this.modified = aminoAcid.modified;
        this.modifiedName = aminoAcid.modifiedName;
    }

    public String getOneLetterCode() {
        return ((AminoAcidFamily)this.getFamily()).getOneLetterCode();
    }

    public String getThreeLetterCode() {
        return this.modified ? this.modifiedName : ((AminoAcidFamily)this.getFamily()).getThreeLetterCode();
    }

    public boolean isModified() {
        return this.modified;
    }

    public Atom getAlphaCarbon() {
        return this.getAtomByName(AtomName.CA);
    }

    public Atom getBetaCarbon() {
        return this.getAtomByName(AtomName.CB);
    }

    public Atom getBackboneCarbon() {
        return this.getAtomByName(AtomName.C);
    }

    public Atom getBackboneNitrogen() {
        return this.getAtomByName(AtomName.N);
    }

    public Atom getBackboneOxygen() {
        return this.getAtomByName(AtomName.O);
    }

    @Override
    public AminoAcid getCopy() {
        return new AminoAcid(this);
    }

    public String getName() {
        return this.getThreeLetterCode();
    }
}

