/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.leaves;

import de.bioforscher.singa.chemistry.parser.pdb.structures.tokens.AtomToken;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.AtomName;
import de.bioforscher.singa.chemistry.physical.interactions.Bond;
import de.bioforscher.singa.chemistry.physical.interactions.BondType;
import de.bioforscher.singa.chemistry.physical.model.Exchangeable;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.StructuralFamily;
import de.bioforscher.singa.chemistry.physical.model.Substructure;
import de.bioforscher.singa.core.utility.Nameable;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import de.bioforscher.singa.mathematics.vectors.Vectors3D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public abstract class LeafSubstructure<LeafSubstructureType extends LeafSubstructure<LeafSubstructureType, FamilyType>, FamilyType extends StructuralFamily>
implements Substructure<LeafSubstructureType, LeafIdentifier>,
Exchangeable<FamilyType>,
Nameable {
    private final LeafIdentifier leafIdentifier;
    private final FamilyType family;
    private Set<FamilyType> exchangeableFamilies;
    private int nextNodeIdentifier;
    private int nextEdgeIdentifier;
    private List<LeafSubstructureType> neighbours;
    private Map<Integer, Atom> atoms;
    private Map<Integer, Bond> bonds;
    private boolean annotatedAsHetAtom;

    public LeafSubstructure(LeafIdentifier leafIdentifier, FamilyType family) {
        this.leafIdentifier = leafIdentifier;
        this.family = family;
        this.neighbours = new ArrayList<LeafSubstructureType>();
        this.atoms = new TreeMap<Integer, Atom>();
        this.bonds = new HashMap<Integer, Bond>();
        this.exchangeableFamilies = new HashSet<FamilyType>();
    }

    public LeafSubstructure(LeafSubstructure<LeafSubstructureType, FamilyType> leafSubstructure) {
        this(leafSubstructure.leafIdentifier, leafSubstructure.family);
        for (Atom atom : leafSubstructure.atoms.values()) {
            this.atoms.put((Integer)atom.getIdentifier(), (Atom)atom.getCopy());
        }
        for (Bond bond : leafSubstructure.bonds.values()) {
            Bond edgeCopy = bond.getCopy();
            Atom sourceCopy = this.atoms.get(((Atom)bond.getSource()).getIdentifier());
            Atom targetCopy = this.atoms.get(((Atom)bond.getTarget()).getIdentifier());
            this.addEdgeBetween(edgeCopy, sourceCopy, targetCopy);
        }
        this.exchangeableFamilies.addAll(leafSubstructure.getExchangeableFamilies());
        this.annotatedAsHetAtom = leafSubstructure.annotatedAsHetAtom;
    }

    public LeafIdentifier getIdentifier() {
        return this.leafIdentifier;
    }

    public Collection<Atom> getNodes() {
        return this.atoms.values();
    }

    public Atom getNode(Integer identifier) {
        return this.atoms.get(identifier);
    }

    public Integer addNode(Atom atom) {
        this.atoms.put((Integer)atom.getIdentifier(), atom);
        return (Integer)atom.getIdentifier();
    }

    public Atom removeNode(Integer identifier) {
        Atom atomToBeRemoved = this.getNode(identifier);
        for (Atom neighbor : atomToBeRemoved.getNeighbours()) {
            neighbor.getNeighbours().remove(atomToBeRemoved);
        }
        this.atoms.remove(atomToBeRemoved.getIdentifier());
        this.bonds.entrySet().removeIf(edge -> ((Bond)((Object)((Object)edge.getValue()))).containsNode(atomToBeRemoved));
        return atomToBeRemoved;
    }

    public Atom removeNode(Atom node) {
        return this.removeNode((Integer)node.getIdentifier());
    }

    public boolean containsNode(Object node) {
        return this.atoms.containsValue(node);
    }

    public boolean containsAtomWithName(AtomName atomName) {
        return this.atoms.values().stream().map(Atom::getAtomNameString).anyMatch(name -> name.equals(atomName.getName()));
    }

    public int nextEdgeIdentifier() {
        return this.nextEdgeIdentifier++;
    }

    public Set<Bond> getEdges() {
        return new HashSet<Bond>(this.bonds.values());
    }

    public Bond getEdge(int identifier) {
        return this.bonds.get(identifier);
    }

    public int addEdgeBetween(int identifier, Atom source, Atom target) {
        return this.addEdgeBetween(new Bond(identifier), source, target);
    }

    public int addEdgeBetween(Bond edge, Atom source, Atom target) {
        if (source == null || target == null) {
            return 0;
        }
        edge.setSource(source);
        edge.setTarget(target);
        this.bonds.put(edge.getIdentifier(), edge);
        source.addNeighbour(target);
        target.addNeighbour(source);
        return edge.getIdentifier();
    }

    public int addEdgeBetween(Atom source, Atom target) {
        return this.addEdgeBetween(this.nextEdgeIdentifier(), source, target);
    }

    public int addEdgeBetween(Atom source, Atom target, BondType type) {
        return this.addEdgeBetween(new Bond(this.nextEdgeIdentifier(), type), source, target);
    }

    public boolean containsEdge(Object edge) {
        return this.bonds.containsValue(edge);
    }

    @Override
    public FamilyType getFamily() {
        return this.family;
    }

    public Vector3D getPosition() {
        return Vectors3D.getCentroid((Collection)this.atoms.values().stream().map(Node::getPosition).collect(Collectors.toList()));
    }

    public void setPosition(Vector3D position) {
        this.atoms.values().forEach(atom -> atom.setPosition(((Vector3D)atom.getPosition()).add(position)));
    }

    public void addNeighbour(LeafSubstructureType node) {
        if (this.equals(node)) {
            throw new IllegalArgumentException("Can not establish self reference between two identical leaves.");
        }
        this.neighbours.add(node);
    }

    public List<LeafSubstructureType> getNeighbours() {
        return this.neighbours;
    }

    public int getDegree() {
        return this.neighbours.size();
    }

    @Override
    public List<Atom> getAllAtoms() {
        return new ArrayList<Atom>(this.atoms.values());
    }

    public Atom getAtomByName(AtomName atomName) {
        return this.getNodes().stream().filter(StructuralEntityFilter.AtomFilter.hasAtomName(atomName)).findAny().orElseThrow(() -> new IllegalArgumentException("could not parse atom name: " + (Object)((Object)atomName)));
    }

    public String getChainIdentifier() {
        return this.leafIdentifier.getChainIdentifier();
    }

    public String getPdbIdentifier() {
        return this.leafIdentifier.getPdbIdentifier();
    }

    public char getInsertionCode() {
        return this.leafIdentifier.getInsertionCode();
    }

    public List<String> getPdbLines() {
        return AtomToken.assemblePDBLine(this);
    }

    public boolean isAnnotatedAsHetAtom() {
        return this.annotatedAsHetAtom;
    }

    public void setAnnotatedAsHetAtom(boolean annotatedAsHetAtom) {
        this.annotatedAsHetAtom = annotatedAsHetAtom;
    }

    @Override
    public Set<FamilyType> getExchangeableFamilies() {
        return this.exchangeableFamilies;
    }

    @Override
    public void addExchangeableFamily(FamilyType exchangeableType) {
        this.exchangeableFamilies.add(exchangeableType);
    }

    public String toString() {
        return this.getIdentifier().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LeafSubstructure that = (LeafSubstructure)o;
        if (!this.family.equals(that.family)) {
            return false;
        }
        return this.leafIdentifier.equals(that.leafIdentifier);
    }

    public int hashCode() {
        int result = this.family.hashCode();
        result = 31 * result + this.leafIdentifier.hashCode();
        return result;
    }

    public Integer nextNodeIdentifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String flatToString() {
        return this.getClass().getSimpleName() + ": " + this.getFamily().getThreeLetterCode() + " " + this.getIdentifier();
    }

    @Override
    public String deepToString() {
        return this.flatToString() + ", with Atoms: {" + this.getNodes().stream().map(atom -> atom.getAtomNameString() + "-" + atom.getIdentifier()).collect(Collectors.joining(", ")) + "}";
    }
}

