/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.physical.model.StructuralFamily;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Exchangeable<R extends StructuralFamily> {
    public R getFamily();

    default public Set<R> getExchangeableFamilies() {
        return Stream.of(this.getFamily()).collect(Collectors.toSet());
    }

    default public Set<R> getContainingFamilies() {
        HashSet<R> types = new HashSet<R>();
        types.add(this.getFamily());
        types.addAll(this.getExchangeableFamilies());
        return types;
    }

    default public void addExchangeableFamily(R exchangeableFamily) {
        this.getExchangeableFamilies().add(exchangeableFamily);
    }
}

