/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.descriptive.elements.ElementProvider;
import de.bioforscher.singa.chemistry.physical.atoms.Atom;
import de.bioforscher.singa.chemistry.physical.atoms.RegularAtom;
import de.bioforscher.singa.chemistry.physical.branches.BranchSubstructure;
import de.bioforscher.singa.chemistry.physical.branches.Chain;
import de.bioforscher.singa.chemistry.physical.branches.StructuralModel;
import de.bioforscher.singa.chemistry.physical.families.LigandFamily;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.AtomContainer;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.leaves.Nucleotide;
import de.bioforscher.singa.chemistry.physical.model.LeafIdentifier;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.UniqueAtomIdentifer;
import de.bioforscher.singa.core.identifier.PDBIdentifier;
import de.bioforscher.singa.mathematics.vectors.Vector3D;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Structure {
    private static final Logger logger = LoggerFactory.getLogger(Structure.class);
    private String pdbIdentifier;
    private String title;
    private Map<Object, BranchSubstructure<?, ?>> branchSubstructures = new TreeMap();
    private int lastAddedAtomIdentifier;

    public String getPdbIdentifier() {
        return this.pdbIdentifier;
    }

    public void setPdbIdentifier(String pdbIdentifier) {
        if (PDBIdentifier.PATTERN.matcher(pdbIdentifier).matches()) {
            this.pdbIdentifier = pdbIdentifier.toLowerCase();
        } else {
            logger.warn("The identifier {} is not a valid PDB identifier. No identifier has been set.", (Object)pdbIdentifier);
        }
    }

    public void setLastAddedAtomIdentifier(int lastAddedAtomIdentifier) {
        this.lastAddedAtomIdentifier = lastAddedAtomIdentifier;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private Collection<BranchSubstructure<?, ?>> getBranchSubstructures() {
        return this.branchSubstructures.values();
    }

    public void addBranchSubstructure(BranchSubstructure<?, ?> branchSubstructure) {
        this.branchSubstructures.put(branchSubstructure.getIdentifier(), branchSubstructure);
    }

    public List<BranchSubstructure<?, ?>> getAllBranches() {
        List<BranchSubstructure<?, ?>> branchSubstructures = this.branchSubstructures.values().stream().map(BranchSubstructure::getBranchSubstructures).flatMap(Collection::stream).collect(Collectors.toList());
        branchSubstructures.addAll(this.branchSubstructures.values());
        return branchSubstructures;
    }

    public List<StructuralModel> getAllModels() {
        return this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isModel()).map(StructuralModel.class::cast).collect(Collectors.toList());
    }

    public StructuralModel getFirstModel() {
        return this.getBranchSubstructures().stream().filter(StructuralEntityFilter.BranchFilter.isModel()).map(StructuralModel.class::cast).findFirst().orElseThrow(() -> new NoSuchElementException("The structure does not contain a model."));
    }

    public List<Chain> getAllChains() {
        return this.getAllBranches().stream().filter(StructuralEntityFilter.BranchFilter.isChain()).map(Chain.class::cast).collect(Collectors.toList());
    }

    public Chain getFirstChain() {
        return this.getFirstModel().getFirstChain();
    }

    public Optional<Chain> getChain(String chainIdentifier) {
        return this.getFirstModel().getAllChains().stream().filter(StructuralEntityFilter.BranchFilter.hasIdentifier(chainIdentifier)).findAny();
    }

    public List<LeafSubstructure<?, ?>> getAllLeafSubstructures() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getLeafSubstructures).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<AminoAcid> getAllAminoAcids() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getAminoAcids).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Nucleotide> getAllNucleotides() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getNucleotides).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Atom> getAllAtoms() {
        return this.branchSubstructures.values().stream().map(BranchSubstructure::getAllAtoms).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<LeafSubstructure<?, ?>> getLeafSubstructure(LeafIdentifier identifier) {
        for (StructuralModel model : this.getAllModels()) {
            for (Chain chain : model.getAllChains()) {
                for (LeafSubstructure<?, ?> leafSubstructure : chain.getLeafSubstructures()) {
                    if (!leafSubstructure.getIdentifier().equals(identifier)) continue;
                    return Optional.of(leafSubstructure);
                }
            }
        }
        return Optional.empty();
    }

    public Optional<Map.Entry<UniqueAtomIdentifer, Atom>> getAtom(int atomSerial) {
        for (StructuralModel model : this.getAllModels()) {
            for (Chain chain : model.getAllChains()) {
                for (LeafSubstructure<?, ?> leafSubstructure : chain.getLeafSubstructures()) {
                    for (Atom atom : leafSubstructure.getAllAtoms()) {
                        if (!((Integer)atom.getIdentifier()).equals(atomSerial)) continue;
                        UniqueAtomIdentifer identifier = new UniqueAtomIdentifer(this.pdbIdentifier, (Integer)model.getIdentifier(), (String)chain.getIdentifier(), leafSubstructure.getIdentifier().getSerial(), leafSubstructure.getIdentifier().getInsertionCode(), atomSerial);
                        return Optional.of(new AbstractMap.SimpleEntry<UniqueAtomIdentifer, Atom>(identifier, atom));
                    }
                }
            }
        }
        return Optional.empty();
    }

    public String toString() {
        return "Structure{pdbIdentifier='" + this.pdbIdentifier + '\'' + ", title='" + this.title + '\'' + '}';
    }

    public void addPseudoAtom(String chain, String threeLetterCode, Vector3D position) {
        Chain leafChain = this.getFirstModel().getAllChains().stream().filter(c -> ((String)c.getIdentifier()).equals(chain)).findFirst().orElseThrow(() -> new IllegalArgumentException("Could not find given chain to add an atom to."));
        AtomContainer<LigandFamily> container = new AtomContainer<LigandFamily>(leafChain.getNextLeafIdentifier(), new LigandFamily(threeLetterCode));
        ++this.lastAddedAtomIdentifier;
        container.addNode(new RegularAtom(this.lastAddedAtomIdentifier, ElementProvider.UNKOWN, "CA", position));
        leafChain.addSubstructure(container);
    }
}

