/*
 * Decompiled with CFR 0.152.
 */
package de.bioforscher.singa.chemistry.physical.model;

import de.bioforscher.singa.chemistry.physical.branches.StructuralMotif;
import de.bioforscher.singa.chemistry.physical.leaves.AminoAcid;
import de.bioforscher.singa.chemistry.physical.leaves.LeafSubstructure;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntity;
import de.bioforscher.singa.chemistry.physical.model.StructuralEntityFilter;
import de.bioforscher.singa.chemistry.physical.model.Structure;
import de.bioforscher.singa.mathematics.graphs.model.Node;
import de.bioforscher.singa.mathematics.matrices.LabeledSymmetricMatrix;
import de.bioforscher.singa.mathematics.metrics.model.VectorMetricProvider;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class Structures {
    private Structures() {
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?, ?>> calculateDistanceMatrix(StructuralMotif structuralMotif) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralMotif.getLeafSubstructures().stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralMotif.getLeafSubstructures());
        return labeledDistances;
    }

    public static LabeledSymmetricMatrix<LeafSubstructure<?, ?>> calculateSquaredDistanceMatrix(StructuralMotif structuralMotif) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralMotif.getLeafSubstructures().stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralMotif.getLeafSubstructures());
        return labeledDistances;
    }

    public static <EntityType extends StructuralEntity<EntityType, ?>> LabeledSymmetricMatrix<EntityType> calculateDistanceMatrix(List<EntityType> structuralEntities) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralEntities.stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralEntities);
        return labeledDistances;
    }

    public static <EntityType extends StructuralEntity<EntityType, ?>> LabeledSymmetricMatrix<EntityType> calculateSquaredDistanceMatrix(List<EntityType> structuralEntities) {
        LabeledSymmetricMatrix labeledDistances = new LabeledSymmetricMatrix(VectorMetricProvider.SQUARED_EUCLIDEAN_METRIC.calculateDistancesPairwise(structuralEntities.stream().map(Node::getPosition).collect(Collectors.toList())).getElements());
        labeledDistances.setRowLabels(structuralEntities);
        return labeledDistances;
    }

    public static boolean isAlphaCarbonStructure(Structure structure) {
        return structure.getAllLeafSubstructures().stream().filter(AminoAcid.class::isInstance).map(LeafSubstructure::getAllAtoms).flatMap(Collection::stream).noneMatch(StructuralEntityFilter.AtomFilter.isAlphaCarbon().negate().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()));
    }

    public static boolean isBackboneStructure(Structure structure) {
        return structure.getAllLeafSubstructures().stream().filter(AminoAcid.class::isInstance).map(LeafSubstructure::getAllAtoms).flatMap(Collection::stream).noneMatch(StructuralEntityFilter.AtomFilter.isBackbone().negate().and(StructuralEntityFilter.AtomFilter.isHydrogen().negate()).and(StructuralEntityFilter.AtomFilter.isBetaCarbon().negate()));
    }
}

