/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.converter.spring;

import de.bitgrip.ficum.annotation.FicumExpression;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.QueryPrinterVisitor;
import de.bitgrip.ficum.parser.ParseHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class FicumNodeConverter
implements GenericConverter {
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> pairs = new HashSet<GenericConverter.ConvertiblePair>();
        pairs.add(new GenericConverter.ConvertiblePair(String.class, Node.class));
        pairs.add(new GenericConverter.ConvertiblePair(Node.class, String.class));
        return Collections.unmodifiableSet(pairs);
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (sourceType.getType().equals(String.class)) {
            FicumExpression ficumExpressionAnnotation = (FicumExpression)targetType.getAnnotation(FicumExpression.class);
            if (ficumExpressionAnnotation == null || ficumExpressionAnnotation.value().length == 0) {
                throw new IllegalStateException("missing " + FicumExpression.class.getName() + " annotation to node parameter for defining allowedSectorNames");
            }
            return this.convertStringToNode((String)source, ficumExpressionAnnotation.value());
        }
        if (Node.class.isAssignableFrom(sourceType.getType())) {
            return this.convertNodeToString((Node)source);
        }
        throw new IllegalArgumentException("Invalid source type " + source.getClass().getCanonicalName());
    }

    private Node convertStringToNode(String ficumQuery, String[] allowedSectorNames) {
        return ParseHelper.parse((String)ficumQuery, (String[])allowedSectorNames);
    }

    private String convertNodeToString(Node filter) {
        QueryPrinterVisitor queryPrinterVisitor = new QueryPrinterVisitor();
        return queryPrinterVisitor.start(filter);
    }
}

