/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.visitor;

import de.bitgrip.ficum.node.AbstractVisitor;
import de.bitgrip.ficum.node.Comparison;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import de.bitgrip.ficum.node.Visitor;
import de.bitgrip.ficum.visitor.Wildcards;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class JPAPredicateVisitor<T>
extends AbstractVisitor<Predicate> {
    public static final char ESCAPE_CHAR = '\\';
    private CriteriaBuilder criteriaBuilder;
    private Root<T> root;
    private Class<T> queryClass;
    private List<Predicate> predicates;
    private Set<Class<? extends Comparable<?>>> mappedTypes = new HashSet();

    public JPAPredicateVisitor(Class<T> queryClass, Root<T> root, CriteriaBuilder criteriaBuilder) {
        this.queryClass = queryClass;
        this.criteriaBuilder = criteriaBuilder;
        this.root = root;
        this.mappedTypes.add(String.class);
        this.mappedTypes.add(Character.class);
        this.mappedTypes.add(Boolean.class);
        this.mappedTypes.add(Double.class);
        this.mappedTypes.add(Integer.class);
        this.mappedTypes.add(Float.class);
        this.mappedTypes.add(Short.class);
        this.mappedTypes.add(Long.class);
        this.mappedTypes.add(Byte.class);
        this.mappedTypes.add(BigInteger.class);
        this.mappedTypes.add(BigDecimal.class);
        this.mappedTypes.add(Date.class);
        this.mappedTypes.add(Calendar.class);
        this.mappedTypes.add(UUID.class);
        this.mappedTypes.add(OffsetDateTime.class);
        this.mappedTypes.add(LocalDate.class);
    }

    private static boolean containsEscapedChar(String value) {
        return value.contains("\\%") || value.contains("\\\\") || value.contains("\\_");
    }

    public boolean addMappedType(Class<? extends Comparable<?>> mappedType) {
        return this.mappedTypes.add(mappedType);
    }

    private Predicate buildEquals(Object value, Expression<? extends Comparable> path) {
        String theValue;
        String originalValue;
        Predicate pred = value == null ? path.isNull() : (path.getJavaType().equals(String.class) ? (JPAPredicateVisitor.containsWildcard((String)(originalValue = value.toString())) || this.isAlwaysWildcard() ? (JPAPredicateVisitor.containsEscapedChar(theValue = Wildcards.escapeAndConvertToSQLWildcards(originalValue, this.isAlwaysWildcard())) ? this.criteriaBuilder.like(path, theValue, '\\') : this.criteriaBuilder.like(path, theValue)) : this.criteriaBuilder.equal(path, (Object)originalValue)) : this.criteriaBuilder.equal(path, value));
        return pred;
    }

    private Predicate buildNotEquals(Object value, Expression<? extends Comparable> path) {
        String theValue;
        String originalValue;
        Predicate pred = value == null ? path.isNotNull() : (path.getJavaType().equals(String.class) ? (JPAPredicateVisitor.containsWildcard((String)(originalValue = value.toString())) || this.isAlwaysWildcard() ? (JPAPredicateVisitor.containsEscapedChar(theValue = Wildcards.escapeAndConvertToSQLWildcards(originalValue, this.isAlwaysWildcard())) ? this.criteriaBuilder.notLike(path, theValue, '\\') : this.criteriaBuilder.notLike(path, theValue)) : this.criteriaBuilder.notEqual(path, (Object)originalValue)) : this.criteriaBuilder.notEqual(path, value));
        return pred;
    }

    private Predicate doBuildCollectionSizePredicate(Comparison comparison, Path<?> path, Integer argument) {
        Expression exp = this.criteriaBuilder.size(path);
        switch (comparison) {
            case GREATER_THAN: {
                return this.criteriaBuilder.greaterThan(exp, (Comparable)argument);
            }
            case EQUALS: {
                return this.criteriaBuilder.equal(exp, (Object)argument);
            }
            case NOT_EQUALS: {
                return this.criteriaBuilder.notEqual(exp, (Object)argument);
            }
            case LESS_THAN: {
                return this.criteriaBuilder.lessThan(exp, (Comparable)argument);
            }
            case LESS_EQUALS: {
                return this.criteriaBuilder.lessThanOrEqualTo(exp, (Comparable)argument);
            }
            case GREATER_EQUALS: {
                return this.criteriaBuilder.greaterThanOrEqualTo(exp, (Comparable)argument);
            }
        }
        return null;
    }

    private Predicate doBuildPredicate(Comparison comparison, Expression<? extends Comparable> path, Comparable argument) {
        switch (comparison) {
            case GREATER_THAN: {
                return this.criteriaBuilder.greaterThan(path, argument);
            }
            case EQUALS: {
                return this.buildEquals(argument, path);
            }
            case NOT_EQUALS: {
                return this.buildNotEquals(argument, path);
            }
            case LESS_THAN: {
                return this.criteriaBuilder.lessThan(path, argument);
            }
            case LESS_EQUALS: {
                return this.criteriaBuilder.lessThanOrEqualTo(path, argument);
            }
            case GREATER_EQUALS: {
                return this.criteriaBuilder.greaterThanOrEqualTo(path, argument);
            }
        }
        return null;
    }

    private Predicate doBuildPredicate(Comparison comparison, Expression<? extends Comparable> path, List<Comparable> argument) {
        switch (comparison) {
            case IN: {
                return path.in(argument);
            }
            case NIN: {
                return this.criteriaBuilder.not((Expression)path.in(argument));
            }
        }
        return null;
    }

    private Path<?> findPath(String names) {
        Path path = this.root;
        Class<Object> clazz = this.queryClass;
        Iterator<String> namesIterator = Arrays.asList(names.split("\\.")).iterator();
        while (namesIterator.hasNext()) {
            String name = namesIterator.next();
            boolean isLast = !namesIterator.hasNext();
            Field field = this.getField(clazz, name);
            if (this.isMappedType(clazz = field.getType())) {
                if (isLast) {
                    path = path.get(name);
                    continue;
                }
                throw new IllegalArgumentException(String.format("%s resolves to %s and can not contain a nested property", name, clazz.getName()));
            }
            if (this.isCollection(clazz)) {
                clazz = this.getGenericTypeClazz((ParameterizedType)field.getGenericType());
                if (isLast && !this.isMappedType(clazz)) {
                    path = path.get(name);
                    continue;
                }
                path = this.getOrCreateJoin(path, name);
                continue;
            }
            if (!(path instanceof From)) continue;
            path = this.getOrCreateJoin(path, name);
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("%s can not be applied to %s", names, this.queryClass.getName()));
        }
        return path;
    }

    private Path<?> getExistingJoin(From<?, ?> element, String prop) {
        Set joins = element.getJoins();
        for (Object object : joins) {
            Join join = (Join)object;
            if (!join.getAttribute().getName().equals(prop)) continue;
            return join;
        }
        return null;
    }

    private Field getField(Class<?> clazz, String name) {
        Field field = FieldUtils.getField(clazz, (String)name, (boolean)true);
        if (field == null) {
            throw new IllegalArgumentException(String.format("Can not find field %s in %s", name, clazz.getName()));
        }
        return field;
    }

    private Class<?> getGenericTypeClazz(ParameterizedType type) {
        Map typeArguments = TypeUtils.getTypeArguments((ParameterizedType)type);
        Iterator it = typeArguments.values().iterator();
        if (it.hasNext()) {
            return TypeUtils.getRawType((Type)((Type)it.next()), null);
        }
        return Object.class;
    }

    private Path<?> getOrCreateJoin(Path<?> path, String name) {
        Path<?> ret = this.getExistingJoin((From)path, name);
        if (ret != null) {
            return ret;
        }
        return path.equals(this.root) ? this.root.join(name) : ((From)path).join(name);
    }

    private boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private boolean isCollectionSizeCheck(Path<?> path, Comparable<?> argument) {
        return this.isCollection(path.getJavaType()) && argument instanceof Integer;
    }

    private boolean isMappedType(Class<?> clazz) {
        for (Class<Comparable<?>> mappedType : this.mappedTypes) {
            if (!mappedType.isAssignableFrom(clazz) && !clazz.isEnum()) continue;
            return true;
        }
        return false;
    }

    public Predicate start(Node node) {
        this.predicates = new ArrayList<Predicate>();
        node.accept((Visitor)this);
        return this.criteriaBuilder.and(this.predicates.toArray(new Predicate[this.predicates.size()]));
    }

    public void visit(ConstraintNode node) {
        Path<?> path = this.findPath(this.getMappedField(node.getSelector()));
        Class clazz = path.getJavaType();
        Object argument = node.getArgument();
        Predicate pred = null;
        if (argument instanceof Comparable) {
            Comparable value = (Comparable)argument;
            if (value instanceof String && clazz.isEnum()) {
                value = Enum.valueOf(clazz, value.toString());
            }
            if (value instanceof LocalDate && clazz.isAssignableFrom(Date.class)) {
                value = Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.of("UTC")).toInstant());
            }
            if (value instanceof LocalDate && clazz.isAssignableFrom(Calendar.class)) {
                value = GregorianCalendar.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.of("UTC")));
            }
            if (value instanceof LocalDate && clazz.isAssignableFrom(OffsetDateTime.class)) {
                value = OffsetDateTime.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.of("UTC")));
            }
            if (value instanceof OffsetDateTime && clazz.isAssignableFrom(Date.class)) {
                value = Date.from(((OffsetDateTime)value).toInstant());
            }
            if (value instanceof OffsetDateTime && clazz.isAssignableFrom(Calendar.class)) {
                value = GregorianCalendar.from(((OffsetDateTime)value).toZonedDateTime());
            }
            pred = this.isCollectionSizeCheck(path, value) ? this.doBuildCollectionSizePredicate(node.getComparison(), path, (Integer)value) : this.doBuildPredicate(node.getComparison(), (Expression<Comparable>)path.as(clazz), value);
        } else if (argument instanceof List) {
            pred = this.doBuildPredicate(node.getComparison(), (Expression<Comparable>)path.as(clazz), this.sanatizeToComparable((List)argument));
        } else if (argument == null) {
            pred = this.doBuildPredicate(node.getComparison(), (Expression<Comparable>)path.as(clazz), (Comparable)null);
        } else {
            throw new IllegalArgumentException("Unable to handle argument of type " + argument.getClass().getName());
        }
        if (pred == null) {
            throw new IllegalArgumentException("Constraint: " + node + " does not resolve to a predicate");
        }
        this.predicates.add(pred);
    }

    public void visit(OperationNode node) {
        node.getLeft().accept((Visitor)this);
        node.getRight().accept((Visitor)this);
        Predicate pred = null;
        switch (node.getOperator()) {
            case AND: {
                pred = this.criteriaBuilder.and((Expression)this.predicates.get(0), (Expression)this.predicates.get(1));
                break;
            }
            case OR: {
                pred = this.criteriaBuilder.or((Expression)this.predicates.get(0), (Expression)this.predicates.get(1));
                break;
            }
            case NAND: {
                pred = this.criteriaBuilder.or((Expression)this.criteriaBuilder.not((Expression)this.predicates.get(0)), (Expression)this.criteriaBuilder.not((Expression)this.predicates.get(1)));
                break;
            }
            case NOR: {
                pred = this.criteriaBuilder.and((Expression)this.criteriaBuilder.not((Expression)this.predicates.get(0)), (Expression)this.criteriaBuilder.not((Expression)this.predicates.get(1)));
                break;
            }
            default: {
                throw new IllegalArgumentException("OperationNode: " + node + " does not resolve to a operation");
            }
        }
        this.predicates.clear();
        this.predicates.add(pred);
    }
}

