/*
 * Decompiled with CFR 0.152.
 */
package de.bitgrip.ficum.visitor;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.LineString;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.client.model.geojson.Polygon;
import com.mongodb.client.model.geojson.Position;
import de.bitgrip.ficum.node.AbstractVisitor;
import de.bitgrip.ficum.node.Comparison;
import de.bitgrip.ficum.node.ConstraintNode;
import de.bitgrip.ficum.node.Node;
import de.bitgrip.ficum.node.OperationNode;
import de.bitgrip.ficum.node.Visitor;
import de.bitgrip.ficum.visitor.Wildcards;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bson.conversions.Bson;

public class MongoDBFilterVisitor
extends AbstractVisitor<Bson> {
    private List<Bson> filters;

    private Bson buildEquals(String fieldName, Comparable<?> argument) {
        Bson pred;
        if (argument instanceof String) {
            String value = (String)((Object)argument);
            if (MongoDBFilterVisitor.containsWildcard((String)value) || this.isAlwaysWildcard()) {
                String regex = Wildcards.escapeAndConvertToRegexWildcards(value, this.isAlwaysWildcard());
                pred = Filters.regex((String)fieldName, (String)regex);
            } else {
                pred = Filters.eq((String)fieldName, (Object)value);
            }
        } else {
            pred = Filters.eq((String)fieldName, argument);
        }
        return pred;
    }

    private Bson buildNotEquals(String fieldName, Comparable<?> argument) {
        Bson pred;
        if (argument instanceof String) {
            String value = (String)((Object)argument);
            if (MongoDBFilterVisitor.containsWildcard((String)value) || this.isAlwaysWildcard()) {
                String regex = Wildcards.escapeAndConvertToRegexWildcards(value, this.isAlwaysWildcard());
                pred = Filters.not((Bson)Filters.regex((String)fieldName, (String)regex));
            } else {
                pred = Filters.ne((String)fieldName, (Object)value);
            }
        } else {
            pred = Filters.ne((String)fieldName, argument);
        }
        return pred;
    }

    private Bson doBuildPredicate(Comparison comparison, String fieldName, List<Comparable> comparables) {
        List<Double> geoargs = this.sanatizeToDouble(comparables);
        block0 : switch (comparison) {
            case NEAR: {
                if (geoargs.size() == 3) {
                    return Filters.nearSphere((String)fieldName, (Point)new Point(new Position(geoargs.get(0).doubleValue(), geoargs.get(1).doubleValue(), new double[0])), (Double)geoargs.get(2), null);
                }
                if (geoargs.size() != 4) break;
                return Filters.nearSphere((String)fieldName, (Point)new Point(new Position(geoargs.get(0).doubleValue(), geoargs.get(1).doubleValue(), new double[0])), (Double)geoargs.get(2), (Double)geoargs.get(3));
            }
            case WITHIN: {
                switch (geoargs.size()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        return Filters.geoWithinCenterSphere((String)fieldName, (double)geoargs.get(0), (double)geoargs.get(1), (double)geoargs.get(2));
                    }
                    case 4: {
                        return Filters.geoWithinBox((String)fieldName, (double)geoargs.get(0), (double)geoargs.get(1), (double)geoargs.get(2), (double)geoargs.get(3));
                    }
                }
                Polygon geometry = new Polygon(this.toPositions(geoargs, true), new List[0]);
                return Filters.geoWithin((String)fieldName, (Geometry)geometry);
            }
            case INTERSECT: {
                switch (geoargs.size()) {
                    case 0: 
                    case 1: 
                    case 3: {
                        break block0;
                    }
                    case 2: {
                        return Filters.geoIntersects((String)fieldName, (Geometry)new Point(new Position(geoargs.get(0).doubleValue(), geoargs.get(1).doubleValue(), new double[0])));
                    }
                    case 4: {
                        return Filters.geoIntersects((String)fieldName, (Geometry)new LineString(this.toPositions(geoargs, false)));
                    }
                }
                Polygon geometry = new Polygon(this.toPositions(geoargs, true), new List[0]);
                return Filters.geoIntersects((String)fieldName, (Geometry)geometry);
            }
            case IN: {
                return Filters.in((String)fieldName, comparables);
            }
            case NIN: {
                return Filters.nin((String)fieldName, comparables);
            }
        }
        return null;
    }

    private Bson doBuildPredicate(Comparison comparison, String fieldName, Comparable<?> argument) {
        switch (comparison) {
            case GREATER_THAN: {
                return Filters.gt((String)fieldName, argument);
            }
            case EQUALS: {
                return this.buildEquals(fieldName, argument);
            }
            case NOT_EQUALS: {
                return this.buildNotEquals(fieldName, argument);
            }
            case LESS_THAN: {
                return Filters.lt((String)fieldName, argument);
            }
            case LESS_EQUALS: {
                return Filters.lte((String)fieldName, argument);
            }
            case GREATER_EQUALS: {
                return Filters.gte((String)fieldName, argument);
            }
        }
        return null;
    }

    public Bson start(Node node) {
        this.filters = new ArrayList<Bson>();
        node.accept((Visitor)this);
        if (this.filters.size() != 1) {
            throw new IllegalStateException("single predicate expected, but was: " + this.filters);
        }
        return this.filters.get(0);
    }

    private List<Position> toPositions(List<Double> arguments, boolean close) {
        Iterator<Double> it = arguments.iterator();
        ArrayList<Position> positions = new ArrayList<Position>();
        while (it.hasNext()) {
            Double lon = it.next();
            if (!it.hasNext()) continue;
            Double lat = it.next();
            positions.add(new Position(lon.doubleValue(), lat.doubleValue(), new double[0]));
        }
        if (close && positions.size() >= 3 && !((Position)positions.get(0)).equals(positions.get(positions.size() - 1))) {
            positions.add((Position)positions.get(0));
        }
        return positions;
    }

    private List<Double> sanatizeToDouble(List<Comparable> arguments) {
        UnmodifiableIterator value = Iterators.filter(arguments.iterator(), Double.class);
        return Lists.newArrayList((Iterator)value);
    }

    public void visit(ConstraintNode<?> node) {
        Object argument = node.getArgument();
        String fieldName = this.getMappedField(node.getSelector());
        Bson pred = null;
        if (argument instanceof Comparable) {
            Comparable value = (Comparable)argument;
            if (value instanceof OffsetDateTime) {
                value = ((OffsetDateTime)value).toLocalDateTime();
            }
            pred = this.doBuildPredicate(node.getComparison(), fieldName, value);
        } else if (argument instanceof List) {
            pred = this.doBuildPredicate(node.getComparison(), fieldName, this.sanatizeToComparable((List)argument));
        } else if (argument == null) {
            pred = this.doBuildPredicate(node.getComparison(), fieldName, (Comparable)null);
        } else {
            throw new IllegalArgumentException("Unable to handle argument of type " + argument.getClass().getName());
        }
        if (pred == null) {
            throw new IllegalArgumentException("Constraint: " + node + " does not resolve to a predicate");
        }
        this.filters.add(pred);
    }

    public void visit(OperationNode node) {
        node.getLeft().accept((Visitor)this);
        node.getRight().accept((Visitor)this);
        Bson pred = null;
        switch (node.getOperator()) {
            case AND: {
                pred = Filters.and((Bson[])new Bson[]{this.filters.get(0), this.filters.get(1)});
                break;
            }
            case OR: {
                pred = Filters.or((Bson[])new Bson[]{this.filters.get(0), this.filters.get(1)});
                break;
            }
            case NAND: {
                pred = Filters.or((Bson[])new Bson[]{Filters.not((Bson)this.filters.get(0)), Filters.not((Bson)this.filters.get(1))});
                break;
            }
            case NOR: {
                pred = Filters.and((Bson[])new Bson[]{Filters.not((Bson)this.filters.get(0)), Filters.not((Bson)this.filters.get(1))});
                break;
            }
            default: {
                throw new IllegalArgumentException("OperationNode: " + node + " does not resolve to a operation");
            }
        }
        this.filters.clear();
        this.filters.add(pred);
    }
}

