/*
 * Decompiled with CFR 0.152.
 */
package de.bitmarck.bms.secon.fs2;

import cats.Applicative;
import cats.Applicative$;
import cats.Functor;
import cats.Monad;
import cats.Monad$;
import cats.data.OptionT$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.std.Dispatcher;
import cats.kernel.Monoid;
import cats.package$;
import cats.syntax.package;
import de.bitmarck.bms.secon.fs2.CertLookup;
import de.bitmarck.bms.secon.fs2.CertSelectors$;
import de.bitmarck.bms.secon.fs2.IdentityLookup;
import de.tk.opensource.secon.Directory;
import de.tk.opensource.secon.SECON;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Optional;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class CertLookup$
implements Serializable {
    public static final CertLookup$ MODULE$ = new CertLookup$();

    private CertLookup$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CertLookup$.class);
    }

    public <F> Monoid<CertLookup<F>> monoid(Monad<F> evidence$1) {
        return package$.MODULE$.Monoid().instance((Object)new CertLookup<F>(evidence$1){
            private final Monad evidence$1$1;
            {
                this.evidence$1$1 = evidence$1$4;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply(this.evidence$1$1);
            }

            public Object certificateByAlias(String alias) {
                return Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).pure((Object)None$.MODULE$);
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return Applicative$.MODULE$.apply((Applicative)this.evidence$1$1).pure((Object)None$.MODULE$);
            }
        }, (Function2 & Serializable)(a, b) -> new CertLookup<F>(evidence$1, (CertLookup)a, (CertLookup)b){
            private final Monad evidence$1$3;
            private final CertLookup a$1;
            private final CertLookup b$1;
            {
                this.evidence$1$3 = evidence$1$5;
                this.a$1 = a$2;
                this.b$1 = b$2;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply(this.evidence$1$3);
            }

            public Object certificateByAlias(String alias) {
                return OptionT$.MODULE$.apply(this.a$1.certificateByAlias(alias)).orElseF(() -> this.certificateByAlias$$anonfun$1(alias), this.evidence$1$3).value();
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return OptionT$.MODULE$.apply(this.a$1.certificateBySelector(selector)).orElseF(() -> this.certificateBySelector$$anonfun$1(selector), this.evidence$1$3).value();
            }

            private final Object certificateByAlias$$anonfun$1(String alias$3) {
                return this.b$1.certificateByAlias(alias$3);
            }

            private final Object certificateBySelector$$anonfun$1(X509CertSelector selector$3) {
                return this.b$1.certificateBySelector(selector$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{certificateByAlias$$anonfun$1(java.lang.String ), certificateBySelector$$anonfun$1(java.security.cert.X509CertSelector )}, serializedLambda);
            }
        });
    }

    public <F> Directory toSeconDirectory(CertLookup<F> certLookup, Dispatcher<F> dispatcher) {
        return new Directory(certLookup, dispatcher){
            private final CertLookup certLookup$1;
            private final Dispatcher dispatcher$1;
            {
                this.certLookup$1 = certLookup$2;
                this.dispatcher$1 = dispatcher$2;
            }

            public Optional certificate(X509CertSelector selector) {
                Option option = OptionConverters$.MODULE$.RichOption((Option)this.dispatcher$1.unsafeRunSync(this.certLookup$1.certificateBySelector(selector)));
                return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
            }

            public Optional certificate(String identifier) {
                Option option = OptionConverters$.MODULE$.RichOption((Option)this.dispatcher$1.unsafeRunSync(this.certLookup$1.certificateByAlias(identifier)));
                return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
            }

            public Optional issuer(X509Certificate cert) {
                return this.certificate(CertSelectors$.MODULE$.issuerOf(cert));
            }
        };
    }

    public <F> CertLookup<F> fromSeconDirectory(Directory seconDirectory, Sync<F> evidence$2) {
        return new CertLookup<F>(seconDirectory, evidence$2){
            private final Directory seconDirectory$1;
            private final Sync evidence$2$1;
            {
                this.seconDirectory$1 = seconDirectory$2;
                this.evidence$2$1 = evidence$2$2;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$2$1);
            }

            public Object certificateByAlias(String alias) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$2$1).blocking(() -> this.certificateByAlias$$anonfun$2(alias));
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$2$1).blocking(() -> this.certificateBySelector$$anonfun$2(selector));
            }

            private final Option certificateByAlias$$anonfun$2(String alias$4) {
                Optional optional = OptionConverters$.MODULE$.RichOptional(this.seconDirectory$1.certificate(alias$4));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            }

            private final Option certificateBySelector$$anonfun$2(X509CertSelector selector$4) {
                Optional optional = OptionConverters$.MODULE$.RichOptional(this.seconDirectory$1.certificate(selector$4));
                return OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{certificateByAlias$$anonfun$2(java.lang.String ), certificateBySelector$$anonfun$2(java.security.cert.X509CertSelector )}, serializedLambda);
            }
        };
    }

    public <F> CertLookup<F> fromCertificate(X509Certificate certificate, Option<String> expectedAlias, Sync<F> evidence$3) {
        return new CertLookup<F>(certificate, expectedAlias, evidence$3){
            private final X509Certificate certificate$1;
            private final Option expectedAlias$1;
            private final Sync evidence$3$1;
            {
                this.certificate$1 = certificate$2;
                this.expectedAlias$1 = expectedAlias$2;
                this.evidence$3$1 = evidence$3$2;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$3$1);
            }

            public Object certificateByAlias(String alias) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$3$1).delay(() -> this.certificateByAlias$$anonfun$3(alias));
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$3$1).delay(() -> this.certificateBySelector$$anonfun$3(selector));
            }

            private final Option certificateByAlias$$anonfun$3(String alias$5) {
                if (this.expectedAlias$1.forall(arg_0 -> CertLookup$.de$bitmarck$bms$secon$fs2$CertLookup$$anon$6$$_$certificateByAlias$$anonfun$3$$anonfun$1(alias$5, arg_0))) {
                    return Some$.MODULE$.apply((Object)this.certificate$1);
                }
                return None$.MODULE$;
            }

            private final X509Certificate certificateBySelector$$anonfun$3$$anonfun$1() {
                return this.certificate$1;
            }

            private final Option certificateBySelector$$anonfun$3(X509CertSelector selector$5) {
                return Option$.MODULE$.when(selector$5.match(this.certificate$1), this::certificateBySelector$$anonfun$3$$anonfun$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{certificateByAlias$$anonfun$3(java.lang.String ), certificateBySelector$$anonfun$3(java.security.cert.X509CertSelector ), de$bitmarck$bms$secon$fs2$CertLookup$$anon$6$$_$certificateByAlias$$anonfun$3$$anonfun$1(java.lang.String java.lang.String ), certificateBySelector$$anonfun$3$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public <F> Option<String> fromCertificate$default$2() {
        return None$.MODULE$;
    }

    public <F> CertLookup<F> fromIdentityLookup(IdentityLookup<F> identityLookup, Monad<F> evidence$4) {
        return new CertLookup<F>(identityLookup, evidence$4){
            private final IdentityLookup identityLookup$1;
            private final Monad evidence$4$1;
            {
                this.identityLookup$1 = identityLookup$2;
                this.evidence$4$1 = evidence$4$2;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply(this.evidence$4$1);
            }

            public Object certificateByAlias(String alias) {
                return package.functor$.MODULE$.toFunctorOps(this.identityLookup$1.identityByAlias(alias), (Functor)this.evidence$4$1).map(CertLookup$::de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateByAlias$$anonfun$4);
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return package.functor$.MODULE$.toFunctorOps(this.identityLookup$1.identityBySelector(selector), (Functor)this.evidence$4$1).map(CertLookup$::de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateBySelector$$anonfun$4);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateByAlias$$anonfun$4(scala.Option ), de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateBySelector$$anonfun$4(scala.Option )}, serializedLambda);
            }
        };
    }

    public <F> CertLookup<F> fromKeyStore(KeyStore keyStore, Sync<F> evidence$5) {
        return new CertLookup<F>(keyStore, evidence$5){
            private final KeyStore keyStore$1;
            private final Sync evidence$5$1;
            {
                this.keyStore$1 = keyStore$2;
                this.evidence$5$1 = evidence$5$2;
            }

            public Monad monadF() {
                return Monad$.MODULE$.apply((Monad)this.evidence$5$1);
            }

            public Object certificateByAlias(String alias) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$5$1).delay(() -> this.certificateByAlias$$anonfun$5(alias));
            }

            public Object certificateBySelector(X509CertSelector selector) {
                return cats.effect.package$.MODULE$.Sync().apply(this.evidence$5$1).delay(() -> this.certificateBySelector$$anonfun$5(selector));
            }

            private final Option certificateByAlias$$anonfun$5(String alias$7) {
                Certificate certificate = this.keyStore$1.getCertificate(alias$7);
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509Certificate = (X509Certificate)certificate;
                    return Some$.MODULE$.apply((Object)x509Certificate);
                }
                return None$.MODULE$;
            }

            private final Option certificateBySelector$$anonfun$5(X509CertSelector selector$6) {
                return CollectionConverters$.MODULE$.EnumerationHasAsScala(this.keyStore$1.aliases()).asScala().flatMap((Function1 & Serializable)alias -> {
                    X509Certificate x509Certificate;
                    Certificate certificate = this.keyStore$1.getCertificate((String)alias);
                    if (certificate instanceof X509Certificate && selector$6.match(x509Certificate = (X509Certificate)certificate)) {
                        return Some$.MODULE$.apply((Object)x509Certificate);
                    }
                    return None$.MODULE$;
                }).nextOption();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{certificateByAlias$$anonfun$5(java.lang.String ), certificateBySelector$$anonfun$5(java.security.cert.X509CertSelector ), certificateBySelector$$anonfun$5$$anonfun$1(java.security.cert.X509CertSelector java.lang.String )}, serializedLambda);
            }
        };
    }

    public <F> Resource<F, CertLookup<F>> fromLdap(Function0<DirContext> dirContext2, Sync<F> evidence$6) {
        return cats.effect.package$.MODULE$.Resource().make(cats.effect.package$.MODULE$.Sync().apply(evidence$6).blocking(dirContext2), (Function1 & Serializable)dirContext -> cats.effect.package$.MODULE$.Sync().apply(evidence$6).blocking((Function0 & Serializable)() -> {
            this.fromLdap$$anonfun$1$$anonfun$1((DirContext)dirContext);
            return BoxedUnit.UNIT;
        }), evidence$6).map((Function1 & Serializable)dirContext -> this.fromSeconDirectory(SECON.directory(() -> dirContext), evidence$6));
    }

    public <F> Resource<F, CertLookup<F>> fromLdapUri(URI ldapUri, Function1<Hashtable<String, String>, BoxedUnit> configure, Sync<F> evidence$7) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUri.toString());
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        configure.apply(env);
        return this.fromLdap((Function0<DirContext>)((Function0 & Serializable)() -> this.fromLdapUri$$anonfun$1(env)), evidence$7);
    }

    public <F> Function1<Hashtable<String, String>, BoxedUnit> fromLdapUri$default$2() {
        return (JProcedure1 & Serializable)_$17 -> {};
    }

    public static final /* synthetic */ boolean de$bitmarck$bms$secon$fs2$CertLookup$$anon$6$$_$certificateByAlias$$anonfun$3$$anonfun$1(String alias$6, String _$8) {
        String string = _$8;
        String string2 = alias$6;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Option de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateByAlias$$anonfun$4(Option _$10) {
        return _$10.map((Function1 & Serializable)_$11 -> _$11.certificate());
    }

    public static final /* synthetic */ Option de$bitmarck$bms$secon$fs2$CertLookup$$anon$7$$_$certificateBySelector$$anonfun$4(Option _$12) {
        return _$12.map((Function1 & Serializable)_$13 -> _$13.certificate());
    }

    private final void fromLdap$$anonfun$1$$anonfun$1(DirContext dirContext$1) {
        dirContext$1.close();
    }

    private final DirContext fromLdapUri$$anonfun$1(Hashtable env$1) {
        return new InitialDirContext(env$1);
    }
}

