/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.avg;

import de.bixilon.kutil.avg.Average;
import de.bixilon.kutil.collections.CollectionUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/bixilon/kutil/avg/LongAverage;", "Lde/bixilon/kutil/avg/Average;", "", "nanos", "(J)V", "avg", "getAvg", "()Ljava/lang/Long;", "data", "", "Lkotlin/Pair;", "lastAVG", "getNanos", "()J", "updated", "", "add", "", "value", "cleanup", "kutil"})
public final class LongAverage
implements Average<Long> {
    private final long nanos;
    @NotNull
    private final List<Pair<Long, Long>> data;
    private boolean updated;
    private long lastAVG;

    public LongAverage(long nanos) {
        this.nanos = nanos;
        this.data = CollectionUtil.INSTANCE.synchronizedListOf(new Pair[0]);
    }

    @Override
    public long getNanos() {
        return this.nanos;
    }

    @Override
    @NotNull
    public synchronized Long getAvg() {
        if (!this.updated) {
            return this.lastAVG;
        }
        this.cleanup();
        List data = CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.data);
        if (data.size() == 0) {
            return 0L;
        }
        long total = 0L;
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            long value = ((Number)((Pair)iterator.next()).component2()).longValue();
            total += value;
        }
        this.lastAVG = total / (long)data.size();
        this.updated = false;
        return this.lastAVG;
    }

    @Override
    public void cleanup() {
        long time = System.nanoTime();
        int indexOffset = 0;
        Iterator iterator = CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.data).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Pair pair = (Pair)iterator.next();
            long addTime = ((Number)pair.component1()).longValue();
            long addDelta = time - addTime;
            if (addDelta - this.getNanos() < 0L) break;
            this.data.remove(index - indexOffset);
            int n2 = indexOffset;
            indexOffset = n2 + 1;
            this.updated = true;
        }
    }

    @Override
    public void add(long value) {
        this.cleanup();
        long time = System.nanoTime();
        ((Collection)this.data).add(new Pair((Object)time, (Object)value));
        this.updated = true;
    }

    @Override
    public void plusAssign(long value) {
        Average.DefaultImpls.plusAssign(this, value);
    }
}

