/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.collections.map.LockMap;
import de.bixilon.kutil.collections.map.SynchronizedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JO\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062*\u0010\u0007\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\t\u00a2\u0006\u0002\u0010\nJ+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\u0004\b\u0000\u0010\u00062\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006\u00a2\u0006\u0002\u0010\u000eJO\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0010\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062*\u0010\u0007\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\t\u00a2\u0006\u0002\u0010\u0011J+\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0013\"\u0004\b\u0000\u0010\u00062\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\b\"\u0002H\u0006\u00a2\u0006\u0002\u0010\u0014J5\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0016\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00172\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\b\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0018J_\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0019\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00010\u00192*\u0010\u0007\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00010\t0\b\"\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u00010\t\u00a2\u0006\u0002\u0010\u001aJ*\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\b2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0086\u0002\u00a2\u0006\u0002\u0010\u001fJ*\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u00162\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0086\u0002\u00a2\u0006\u0002\u0010 J1\u0010!\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u0005*\u00020\u00012\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00050$H\u0002\u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0017J.\u0010'\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0010\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0019J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0013\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0017\u00a8\u0006)"}, d2={"Lde/bixilon/kutil/collections/CollectionUtil;", "", "()V", "lockMapOf", "Lde/bixilon/kutil/collections/map/LockMap;", "K", "V", "pairs", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)Lde/bixilon/kutil/collections/map/LockMap;", "synchronizedListOf", "", "values", "([Ljava/lang/Object;)Ljava/util/List;", "synchronizedMapOf", "Lde/bixilon/kutil/collections/map/SynchronizedMap;", "([Lkotlin/Pair;)Lde/bixilon/kutil/collections/map/SynchronizedMap;", "synchronizedSetOf", "", "([Ljava/lang/Object;)Ljava/util/Set;", "extend", "", "", "(Ljava/util/Collection;[Ljava/lang/Object;)Ljava/util/List;", "", "(Ljava/util/Map;[Lkotlin/Pair;)Ljava/util/Map;", "get", "T", "enum", "", "([Ljava/lang/Object;Ljava/lang/Enum;)Ljava/lang/Object;", "(Ljava/util/List;Ljava/lang/Enum;)Ljava/lang/Object;", "synchronizedCopy", "lock", "copier", "Lkotlin/Function0;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "toSynchronizedList", "toSynchronizedMap", "toSynchronizedSet", "kutil"})
public final class CollectionUtil {
    @NotNull
    public static final CollectionUtil INSTANCE = new CollectionUtil();

    private CollectionUtil() {
    }

    @NotNull
    public final <K, V> LockMap<K, V> lockMapOf(Pair<? extends K, ? extends V> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return new LockMap(MapsKt.mutableMapOf(Arrays.copyOf(pairs, pairs.length)));
    }

    @NotNull
    public final <K, V> SynchronizedMap<K, V> synchronizedMapOf(Pair<? extends K, ? extends V> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return new SynchronizedMap(MapsKt.mutableMapOf(Arrays.copyOf(pairs, pairs.length)));
    }

    @NotNull
    public final <V> Set<V> synchronizedSetOf(V ... values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Set set = Collections.synchronizedSet(SetsKt.mutableSetOf((Object[])Arrays.copyOf(values, values.length)));
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(mutableSetOf(*values))");
        return set;
    }

    @NotNull
    public final <V> List<V> synchronizedListOf(V ... values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        List list = Collections.synchronizedList(CollectionsKt.mutableListOf((Object[])Arrays.copyOf(values, values.length)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(mutableListOf(*values))");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <K> K synchronizedCopy(Object $this$synchronizedCopy, Object lock, Function0<? extends K> copier) {
        Object ret = null;
        Object object = lock;
        if (object == null) {
            object = $this$synchronizedCopy;
        }
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            ret = copier.invoke();
            Unit unit = Unit.INSTANCE;
        }
        return (K)ret;
    }

    static /* synthetic */ Object synchronizedCopy$default(CollectionUtil collectionUtil, Object object, Object object2, Function0 function0, int n, Object object3) {
        if ((n & 1) != 0) {
            object2 = null;
        }
        return collectionUtil.synchronizedCopy(object, object2, function0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> SynchronizedMap<K, V> toSynchronizedMap(@NotNull Map<K, ? extends V> $this$toSynchronizedMap) {
        SynchronizedMap synchronizedMap;
        Intrinsics.checkNotNullParameter($this$toSynchronizedMap, (String)"<this>");
        Map<K, ? extends V> map = $this$toSynchronizedMap;
        if (map instanceof LockMap) {
            ((LockMap)$this$toSynchronizedMap).getLock().acquire();
            SynchronizedMap map2 = (SynchronizedMap)CastUtil.INSTANCE.unsafeCast(new SynchronizedMap(MapsKt.toMutableMap($this$toSynchronizedMap)));
            ((LockMap)$this$toSynchronizedMap).getLock().release();
            synchronizedMap = map2;
        } else if (map instanceof SynchronizedMap) {
            void var3_4;
            Object map3 = null;
            Object object = ((SynchronizedMap)$this$toSynchronizedMap).getLock();
            synchronized (object) {
                boolean bl = false;
                map3 = CastUtil.INSTANCE.unsafeCast(new SynchronizedMap(MapsKt.toMutableMap($this$toSynchronizedMap)));
                Unit unit = Unit.INSTANCE;
            }
            synchronizedMap = (SynchronizedMap)var3_4;
        } else {
            synchronizedMap = (SynchronizedMap)CollectionUtil.synchronizedCopy$default(this, $this$toSynchronizedMap, null, new Function0<SynchronizedMap<K, V>>($this$toSynchronizedMap){
                final /* synthetic */ Map<K, V> $this_toSynchronizedMap;
                {
                    this.$this_toSynchronizedMap = $receiver;
                    super(0);
                }

                @NotNull
                public final SynchronizedMap<K, V> invoke() {
                    return new SynchronizedMap<K, V>(MapsKt.toMutableMap(this.$this_toSynchronizedMap));
                }
            }, 1, null);
        }
        return synchronizedMap;
    }

    @NotNull
    public final <V> List<V> toSynchronizedList(@NotNull Collection<? extends V> $this$toSynchronizedList) {
        Intrinsics.checkNotNullParameter($this$toSynchronizedList, (String)"<this>");
        Object object = CollectionUtil.synchronizedCopy$default(this, $this$toSynchronizedList, null, new Function0<List<V>>($this$toSynchronizedList){
            final /* synthetic */ Collection<V> $this_toSynchronizedList;
            {
                this.$this_toSynchronizedList = $receiver;
                super(0);
            }

            public final List<V> invoke() {
                return Collections.synchronizedList(CollectionsKt.toMutableList(this.$this_toSynchronizedList));
            }
        }, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Collection<V>.toSynchron\u2026t(this.toMutableList()) }");
        return (List)object;
    }

    @NotNull
    public final <V> Set<V> toSynchronizedSet(@NotNull Collection<? extends V> $this$toSynchronizedSet) {
        Intrinsics.checkNotNullParameter($this$toSynchronizedSet, (String)"<this>");
        Object object = CollectionUtil.synchronizedCopy$default(this, $this$toSynchronizedSet, null, new Function0<Set<V>>($this$toSynchronizedSet){
            final /* synthetic */ Collection<V> $this_toSynchronizedSet;
            {
                this.$this_toSynchronizedSet = $receiver;
                super(0);
            }

            public final Set<V> invoke() {
                return Collections.synchronizedSet(CollectionsKt.toMutableSet((Iterable)this.$this_toSynchronizedSet));
            }
        }, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Collection<V>.toSynchron\u2026et(this.toMutableSet()) }");
        return (Set)object;
    }

    @NotNull
    public final <K, V> Map<K, V> extend(@NotNull Map<K, ? extends Object> $this$extend, Pair<? extends K, ? extends Object> ... pairs) {
        Object t;
        Object object;
        Intrinsics.checkNotNullParameter($this$extend, (String)"<this>");
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        Map map = new LinkedHashMap();
        for (Map.Entry<K, Object> entry : $this$extend.entrySet()) {
            K key = entry.getKey();
            Object value = entry.getValue();
            object = map;
            t = CastUtil.INSTANCE.unsafeCast(value);
            object.put(key, t);
        }
        for (Pair<? extends K, ? extends Object> pair : pairs) {
            Map map2 = map;
            object = pair.getFirst();
            t = CastUtil.INSTANCE.unsafeCast(pair.getSecond());
            map2.put(object, t);
        }
        return MapsKt.toMap((Map)map);
    }

    @NotNull
    public final <V> List<V> extend(@NotNull Collection<? extends V> $this$extend, Object ... values) {
        Intrinsics.checkNotNullParameter($this$extend, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        List list = new ArrayList();
        for (V value : $this$extend) {
            ((Collection)list).add(CastUtil.INSTANCE.unsafeCast(value));
        }
        for (Object value : values) {
            CollectionUtil.extend$add(list, value);
        }
        return CollectionsKt.toList((Iterable)list);
    }

    public final <T> T get(@NotNull List<? extends T> $this$get, @NotNull Enum<?> enum_) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(enum_, (String)"enum");
        return $this$get.get(enum_.ordinal());
    }

    public final <T> T get(@NotNull T[] $this$get, @NotNull Enum<?> enum_) {
        Intrinsics.checkNotNullParameter($this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter(enum_, (String)"enum");
        return $this$get[enum_.ordinal()];
    }

    private static final <V> void extend$add(List<V> list, Object value) {
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                CollectionUtil.extend$add(list, element);
            }
        } else {
            ((Collection)list).add(CastUtil.INSTANCE.unsafeCast(value));
        }
    }
}

