/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.pool;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.pool.ThreadPoolStates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u0000 02\u00020\u0001:\u00010B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\nJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J0\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0 0\u0012\"\u0004\b\u0000\u0010!2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H!0#0\"H\u0016J@\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0 0\u0012\"\u0004\b\u0000\u0010!2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H!0#0\"2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0019H\u0016J)\u0010%\u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H!0#0\"H\u0016\u00a2\u0006\u0002\u0010&J9\u0010%\u001a\u0002H!\"\u0004\b\u0000\u0010!2\u0014\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H!0#0\"2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0015H\u0016J\b\u0010)\u001a\u00020\u0015H\u0016J\u0011\u0010*\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\nH\u0086\u0002J\u0011\u0010*\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002J\b\u0010+\u001a\u00020\u001bH\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0012H\u0016J\b\u0010-\u001a\u00020\u001bH\u0002J\u0014\u0010.\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J)\u0010.\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\u0006\u0010\u0016\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u0002H!H\u0016\u00a2\u0006\u0002\u0010/J\"\u0010.\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H!0#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool;", "Ljava/util/concurrent/ExecutorService;", "threadCount", "", "name", "", "(ILjava/lang/String;)V", "nextThreadId", "queue", "Ljava/util/concurrent/PriorityBlockingQueue;", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolRunnable;", "queueSize", "getQueueSize", "()I", "state", "Lde/bixilon/kutil/concurrent/pool/ThreadPoolStates;", "getThreadCount", "threads", "", "Ljava/lang/Thread;", "awaitTermination", "", "p0", "", "p1", "Ljava/util/concurrent/TimeUnit;", "checkThreads", "", "execute", "runnable", "Ljava/lang/Runnable;", "invokeAll", "Ljava/util/concurrent/Future;", "T", "", "Ljava/util/concurrent/Callable;", "p2", "invokeAny", "(Ljava/util/Collection;)Ljava/lang/Object;", "(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "isShutdown", "isTerminated", "plusAssign", "shutdown", "shutdownNow", "startThreadLoop", "submit", "(Ljava/lang/Runnable;Ljava/lang/Object;)Ljava/util/concurrent/Future;", "Priorities", "kutil"})
public class ThreadPool
implements ExecutorService {
    @NotNull
    public static final Priorities Priorities = new Priorities(null);
    private final int threadCount;
    @NotNull
    private final String name;
    @NotNull
    private ThreadPoolStates state;
    @NotNull
    private List<Thread> threads;
    @NotNull
    private PriorityBlockingQueue<ThreadPoolRunnable> queue;
    private int nextThreadId;
    public static final int HIGHEST = Integer.MAX_VALUE;
    public static final int HIGHER = 500;
    public static final int HIGH = 100;
    public static final int NORMAL = 0;
    public static final int LOW = -100;
    public static final int LOWER = -500;
    public static final int LOWEST = Integer.MIN_VALUE;

    public ThreadPool(int threadCount, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.threadCount = threadCount;
        this.name = name;
        this.state = ThreadPoolStates.STARTING;
        this.threads = CollectionUtil.INSTANCE.synchronizedListOf(new Thread[0]);
        this.queue = new PriorityBlockingQueue();
        if (!(this.threadCount >= 1)) {
            boolean bl = false;
            String string = "Can not have < 1 thread!";
            throw new IllegalStateException(string.toString());
        }
        this.checkThreads();
        this.state = ThreadPoolStates.STARTED;
    }

    public /* synthetic */ ThreadPool(int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if ((n2 & 2) != 0) {
            string = "Worker#%d";
        }
        this(n, string);
    }

    public final int getThreadCount() {
        return this.threadCount;
    }

    public final int getQueueSize() {
        return this.queue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startThreadLoop() {
        ThreadPoolRunnable runnable = null;
        while (this.state != ThreadPoolStates.STOPPING) {
            try {
                ThreadPoolRunnable threadPoolRunnable = this.queue.take();
                Intrinsics.checkNotNullExpressionValue((Object)threadPoolRunnable, (String)"queue.take()");
                runnable = threadPoolRunnable;
            }
            catch (InterruptedException exception) {
                break;
            }
            try {
                runnable.setThread(Thread.currentThread());
                Runnable runnable2 = runnable.getRunnable();
                if (runnable2 != null) {
                    runnable2.run();
                }
                runnable.setThread(null);
            }
            catch (InterruptedException exception) {
                runnable.setWasInterrupted(true);
                ((Collection)this.queue).add(runnable);
                if (this.state != ThreadPoolStates.STOPPING) continue;
                break;
            }
            catch (Throwable exception) {
                exception.printStackTrace();
            }
            finally {
                runnable.setThread(null);
            }
        }
    }

    private final synchronized void checkThreads() {
        int n = 0;
        int n2 = this.threadCount - this.threads.size();
        while (n < n2) {
            int i = n++;
            Thread thread = new Thread(() -> ThreadPool.checkThreads$lambda-1(this));
            String string = this.name;
            Object[] objectArray = new Object[1];
            int n3 = this.nextThreadId;
            this.nextThreadId = n3 + 1;
            objectArray[0] = n3;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            thread.setName(string2);
            thread.start();
            ((Collection)this.threads).add(thread);
        }
    }

    public final synchronized void execute(@NotNull ThreadPoolRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        ((Collection)this.queue).add(runnable);
    }

    @Override
    public void execute(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(new ThreadPoolRunnable(0, false, runnable, 3, null));
    }

    public final void plusAssign(@NotNull ThreadPoolRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(runnable);
    }

    public final void plusAssign(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        this.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.state = ThreadPoolStates.STOPPING;
        List<Thread> list = this.threads;
        synchronized (list) {
            boolean bl = false;
            for (Thread thread : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.threads)) {
                thread.interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        while (!((Collection)this.threads).isEmpty()) {
            Thread.sleep(1L);
        }
        this.state = ThreadPoolStates.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.state = ThreadPoolStates.STOPPING;
        List<Thread> list = this.threads;
        synchronized (list) {
            boolean bl = false;
            for (Thread thread : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.threads)) {
                thread.interrupt();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.state = ThreadPoolStates.STOPPED;
        return new ArrayList();
    }

    @Override
    public boolean isShutdown() {
        return this.state == ThreadPoolStates.STOPPING;
    }

    @Override
    public boolean isTerminated() {
        return this.state == ThreadPoolStates.STOPPED;
    }

    @Override
    public boolean awaitTermination(long p0, @NotNull TimeUnit p1) {
        Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Callable<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public <T> Future<T> submit(@NotNull Runnable p0, T p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public Future<?> submit(@NotNull Runnable p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    @Override
    public <T> T invokeAny(@NotNull Collection<? extends Callable<T>> p0, long p1, @NotNull TimeUnit p2) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)((Object)p2), (String)"p2");
        throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)"Not yet implemented"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void checkThreads$lambda-1(ThreadPool this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            this$0.startThreadLoop();
        }
        finally {
            ((Collection)this$0.threads).remove(Thread.currentThread());
        }
    }

    public ThreadPool() {
        this(0, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/bixilon/kutil/concurrent/pool/ThreadPool$Priorities;", "", "()V", "HIGH", "", "HIGHER", "HIGHEST", "LOW", "LOWER", "LOWEST", "NORMAL", "kutil"})
    public static final class Priorities {
        private Priorities() {
        }

        public /* synthetic */ Priorities(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

