/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.time;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.time.TimeWorkerTask;
import de.bixilon.kutil.time.TimeUtil;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0011\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/bixilon/kutil/concurrent/time/TimeWorker;", "", "()V", "TASKS", "", "Lde/bixilon/kutil/concurrent/time/TimeWorkerTask;", "addTask", "", "task", "minusAssign", "plusAssign", "removeTask", "runIn", "millis", "", "runnable", "Ljava/lang/Runnable;", "kutil"})
public final class TimeWorker {
    @NotNull
    public static final TimeWorker INSTANCE = new TimeWorker();
    @NotNull
    private static final Set<TimeWorkerTask> TASKS = CollectionUtil.INSTANCE.synchronizedSetOf(new TimeWorkerTask[0]);

    private TimeWorker() {
    }

    public final void runIn(int millis, @NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        TimeWorkerTask task = new TimeWorkerTask(millis, true, 0, runnable, 4, null);
        task.setLastExecution(TimeUtil.INSTANCE.getTime());
        ((Collection)TASKS).add(task);
    }

    public final void addTask(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ((Collection)TASKS).add(task);
    }

    public final void plusAssign(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.addTask(task);
    }

    public final void removeTask(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ((Collection)TASKS).remove(task);
    }

    public final void minusAssign(@NotNull TimeWorkerTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.removeTask(task);
    }

    private static final void lambda-1$lambda-0(TimeWorkerTask $task, long $currentTime) {
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        if (!$task.getLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
            return;
        }
        if ($task.getExecuting()) {
            $task.getLock().unlock();
            return;
        }
        if (TimeUtil.INSTANCE.getTime() - $currentTime >= (long)$task.getMaxDelayTime()) {
            $task.getLock().unlock();
            return;
        }
        $task.setExecuting(true);
        try {
            $task.getRunnable().run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        $task.setLastExecution($currentTime);
        $task.setExecuting(false);
        $task.getLock().unlock();
    }

    private static final void _init_$lambda-1() {
        while (true) {
            long currentTime = TimeUtil.INSTANCE.getTime();
            for (TimeWorkerTask task : CollectionUtil.INSTANCE.toSynchronizedSet((Collection)TASKS)) {
                if (task.getExecuting() || currentTime - task.getLastExecution() <= (long)task.getInterval()) continue;
                DefaultThreadPool.INSTANCE.plusAssign(() -> TimeWorker.lambda-1$lambda-0(task, currentTime));
                if (!task.getRunOnce()) continue;
                ((Collection)TASKS).remove(task);
            }
            Thread.sleep(1L);
        }
    }

    static {
        new Thread(TimeWorker::_init_$lambda-1, "TimeWorkerThread").start();
    }
}

