/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.concurrent.worker;

import de.bixilon.kutil.collections.CollectionUtil;
import de.bixilon.kutil.concurrent.pool.DefaultThreadPool;
import de.bixilon.kutil.concurrent.pool.ThreadPoolRunnable;
import de.bixilon.kutil.concurrent.worker.TaskWorkerStates;
import de.bixilon.kutil.concurrent.worker.tasks.Task;
import de.bixilon.kutil.latch.CountUpAndDownLatch;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001By\u00128\b\u0002\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00128\b\u0002\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0002\u0010\fJ\u0011\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0004H\u0086\u0002J\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dRJ\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010RJ\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00040\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/bixilon/kutil/concurrent/worker/TaskWorker;", "", "errorHandler", "Lkotlin/Function2;", "Lde/bixilon/kutil/concurrent/worker/tasks/Task;", "Lkotlin/ParameterName;", "name", "task", "", "exception", "", "criticalErrorHandler", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "getCriticalErrorHandler", "()Lkotlin/jvm/functions/Function2;", "setCriticalErrorHandler", "(Lkotlin/jvm/functions/Function2;)V", "getErrorHandler", "setErrorHandler", "<set-?>", "Lde/bixilon/kutil/concurrent/worker/TaskWorkerStates;", "state", "getState", "()Lde/bixilon/kutil/concurrent/worker/TaskWorkerStates;", "todo", "", "plusAssign", "work", "progress", "Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "kutil"})
public final class TaskWorker {
    @NotNull
    private Function2<? super Task, ? super Throwable, Unit> errorHandler;
    @NotNull
    private Function2<? super Task, ? super Throwable, Unit> criticalErrorHandler;
    @NotNull
    private final Map<Object, Task> todo;
    @NotNull
    private TaskWorkerStates state;

    public TaskWorker(@NotNull Function2<? super Task, ? super Throwable, Unit> errorHandler, @NotNull Function2<? super Task, ? super Throwable, Unit> criticalErrorHandler) {
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        Intrinsics.checkNotNullParameter(criticalErrorHandler, (String)"criticalErrorHandler");
        this.errorHandler = errorHandler;
        this.criticalErrorHandler = criticalErrorHandler;
        this.todo = CollectionUtil.INSTANCE.synchronizedMapOf(new Pair[0]);
        this.state = TaskWorkerStates.PREPARING;
    }

    public /* synthetic */ TaskWorker(Function2 function2, Function2 function22, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function2 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function22 = 2.INSTANCE;
        }
        this((Function2<? super Task, ? super Throwable, Unit>)function2, (Function2<? super Task, ? super Throwable, Unit>)function22);
    }

    @NotNull
    public final Function2<Task, Throwable, Unit> getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(@NotNull Function2<? super Task, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.errorHandler = function2;
    }

    @NotNull
    public final Function2<Task, Throwable, Unit> getCriticalErrorHandler() {
        return this.criticalErrorHandler;
    }

    public final void setCriticalErrorHandler(@NotNull Function2<? super Task, ? super Throwable, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.criticalErrorHandler = function2;
    }

    @NotNull
    public final TaskWorkerStates getState() {
        return this.state;
    }

    public final void plusAssign(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(this.state == TaskWorkerStates.PREPARING)) {
            boolean bl = false;
            String string = "Task worker is already working!";
            throw new IllegalStateException(string.toString());
        }
        if (ArraysKt.contains((Object[])task.getDependencies(), (Object)task.getIdentifier())) {
            throw new IllegalArgumentException("Task can not depend on itself!");
        }
        Task previous = this.todo.put(task.getIdentifier(), task);
        if (previous != null) {
            System.err.println("Task " + task.getIdentifier() + " replaced existing task!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void work(@NotNull CountUpAndDownLatch progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        List todo = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)CollectionUtil.INSTANCE.toSynchronizedMap(this.todo).values(), TaskWorker::work$lambda-1));
        Set<Object> done = CollectionUtil.INSTANCE.synchronizedSetOf(new Object[0]);
        Ref.BooleanRef exit = new Ref.BooleanRef();
        CountUpAndDownLatch workerProgress = new CountUpAndDownLatch(1, progress);
        while (!((Collection)todo).isEmpty()) {
            boolean bl;
            Ref.BooleanRef changed = new Ref.BooleanRef();
            block4: for (Task task : CollectionUtil.INSTANCE.toSynchronizedList(todo)) {
                for (Object dependency : task.getDependencies()) {
                    if (done.contains(dependency)) continue;
                    continue block4;
                }
                CountUpAndDownLatch taskProgress = new CountUpAndDownLatch(2, workerProgress);
                ((Collection)todo).remove(task);
                DefaultThreadPool.INSTANCE.plusAssign(new ThreadPoolRunnable(task.getPriority(), false, () -> TaskWorker.work$lambda-4(taskProgress, task, changed, done, this, exit), 2, null));
            }
            if (exit.element) break;
            Boolean bl2 = changed.element;
            synchronized (bl2) {
                boolean bl3 = false;
                bl = changed.element;
            }
            if (bl) continue;
            if (todo.isEmpty()) break;
            workerProgress.waitForChange();
            if (!exit.element) continue;
        }
        workerProgress.dec();
    }

    private static final int work$lambda-1(Task a, Task b) {
        return a.getPriority() - b.getPriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void work$lambda-4(CountUpAndDownLatch $taskProgress, Task $task, Ref.BooleanRef $changed, Set $done, TaskWorker this$0, Ref.BooleanRef $exit) {
        Intrinsics.checkNotNullParameter((Object)$taskProgress, (String)"$taskProgress");
        Intrinsics.checkNotNullParameter((Object)$task, (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$changed, (String)"$changed");
        Intrinsics.checkNotNullParameter((Object)$done, (String)"$done");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exit, (String)"$exit");
        $taskProgress.dec();
        try {
            $task.getExecutor().invoke((Object)$taskProgress);
            Boolean bl = $changed.element;
            synchronized (bl) {
                boolean bl2 = false;
                $changed.element = true;
                Unit unit = Unit.INSTANCE;
            }
            ((Collection)$done).add($task.getIdentifier());
            $taskProgress.dec();
        }
        catch (Throwable exception) {
            if (!(exception instanceof InterruptedException)) {
                exception.printStackTrace();
            }
            Boolean bl = $changed.element;
            synchronized (bl) {
                boolean bl3 = false;
                $changed.element = true;
                Unit unit = Unit.INSTANCE;
            }
            if ($task.getOptional()) {
                $taskProgress.setCount(0);
                this$0.errorHandler.invoke((Object)$task, (Object)exception);
            }
            this$0.criticalErrorHandler.invoke((Object)$task, (Object)exception);
            $exit.element = true;
        }
    }

    public TaskWorker() {
        this(null, null, 3, null);
    }
}

