/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.file;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004R\u0015\u0010\u0003\u001a\u00020\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lde/bixilon/kutil/file/FileUtil;", "", "()V", "slashPath", "", "Ljava/io/File;", "getSlashPath", "(Ljava/io/File;)Ljava/lang/String;", "safeSaveToFile", "", "destination", "content", "kutil"})
public final class FileUtil {
    @NotNull
    public static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public final void safeSaveToFile(@NotNull File destination, @NotNull String content) {
        FileWriter fileWriter;
        File tempFile;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File parent = destination.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException(Intrinsics.stringPlus((String)"Could not create folder: ", (Object)parent.getPath()));
            }
        }
        if ((tempFile = new File(Intrinsics.stringPlus((String)destination.getPath(), (Object)".tmp"))).exists() && !tempFile.delete()) {
            throw new IOException("Could not delete " + tempFile + '!');
        }
        FileWriter $this$safeSaveToFile_u24lambda_u2d0 = fileWriter = new FileWriter(tempFile);
        boolean bl = false;
        $this$safeSaveToFile_u24lambda_u2d0.write(content);
        $this$safeSaveToFile_u24lambda_u2d0.close();
        if (destination.exists() && !destination.delete()) {
            throw new IOException("Could not delete " + destination + '!');
        }
        if (!tempFile.renameTo(destination)) {
            throw new IOException("Could not move " + tempFile + " to " + destination + '!');
        }
    }

    @NotNull
    public final String getSlashPath(@NotNull File $this$slashPath) {
        Intrinsics.checkNotNullParameter((Object)$this$slashPath, (String)"<this>");
        String string = $this$slashPath.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"absolutePath");
        return StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }
}

