/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.latch;

import de.bixilon.kutil.collections.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u0000J\u0012\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010 \u001a\u00020!H\u0007J\u0006\u0010\"\u001a\u00020\tJ\t\u0010#\u001a\u00020\u0000H\u0086\u0002J\t\u0010$\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003J\u0017\u0010&\u001a\u00020\t2\b\b\u0002\u0010'\u001a\u00020\u0000H\u0003\u00a2\u0006\u0002\b(J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0003J\u0017\u0010*\u001a\u00020\t2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0086\u0002J\b\u0010,\u001a\u00020-H\u0016J\u0006\u0010.\u001a\u00020\tR\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0019\u0010\u000fR&\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00038F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000f\u00a8\u0006/"}, d2={"Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "", "count", "", "parent", "(ILde/bixilon/kutil/latch/CountUpAndDownLatch;)V", "changeCallbacks", "", "Lkotlin/Function0;", "", "children", "value", "getCount", "()I", "setCount", "(I)V", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "getParent", "()Lde/bixilon/kutil/latch/CountUpAndDownLatch;", "setParent", "(Lde/bixilon/kutil/latch/CountUpAndDownLatch;)V", "rawCount", "setRawCount", "total", "getTotal", "setTotal", "addChild", "latch", "await", "timeout", "", "awaitWithChange", "dec", "inc", "minus", "notify", "this", "customNotify", "plus", "plusAssign", "callback", "toString", "", "waitForChange", "kutil"})
public final class CountUpAndDownLatch {
    @Nullable
    private CountUpAndDownLatch parent;
    @NotNull
    private final Set<Function0<Unit>> changeCallbacks;
    @NotNull
    private final Object lock;
    @NotNull
    private final Set<CountUpAndDownLatch> children;
    private int rawCount;
    private int total;

    @JvmOverloads
    public CountUpAndDownLatch(int count, @Nullable CountUpAndDownLatch parent) {
        this.parent = parent;
        this.changeCallbacks = new LinkedHashSet();
        this.lock = new Object();
        this.children = CollectionUtil.INSTANCE.synchronizedSetOf(new CountUpAndDownLatch[0]);
        this.total = count;
        if (!(this.parent != this)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        CountUpAndDownLatch countUpAndDownLatch = this.parent;
        if (countUpAndDownLatch != null) {
            countUpAndDownLatch.addChild(this);
        }
        this.setCount(this.getCount() + count);
    }

    public /* synthetic */ CountUpAndDownLatch(int n, CountUpAndDownLatch countUpAndDownLatch, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            countUpAndDownLatch = null;
        }
        this(n, countUpAndDownLatch);
    }

    @Nullable
    public final CountUpAndDownLatch getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable CountUpAndDownLatch countUpAndDownLatch) {
        this.parent = countUpAndDownLatch;
    }

    @NotNull
    public final Object getLock() {
        return this.lock;
    }

    private final void setRawCount(int value) {
        int diff = value - this.rawCount;
        if (!(value >= 0)) {
            boolean bl = false;
            String string = "Can not set count (previous=" + this.rawCount + ", value=" + value + ')';
            throw new IllegalStateException(string.toString());
        }
        if (diff > 0) {
            this.setTotal(this.getTotal() + diff);
        }
        this.rawCount = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCount() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.rawCount;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCount(int value) {
        int diff = 0;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            diff = value - this.rawCount;
            this.setRawCount(value);
            if (value <= 0) {
                this.changeCallbacks.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        CountUpAndDownLatch countUpAndDownLatch = this.parent;
        CountUpAndDownLatch countUpAndDownLatch2 = countUpAndDownLatch == null ? null : countUpAndDownLatch.plus(diff);
        if (countUpAndDownLatch2 == null) {
            CountUpAndDownLatch.customNotify$default(this, null, 1, null);
            countUpAndDownLatch2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTotal() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.total;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setTotal(int value) {
        if (!(value >= 0)) {
            boolean $i$a$-check-CountUpAndDownLatch$total$32 = false;
            String $i$a$-check-CountUpAndDownLatch$total$32 = Intrinsics.stringPlus((String)"Total can not be < 0: ", (Object)value);
            throw new IllegalStateException($i$a$-check-CountUpAndDownLatch$total$32.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (!(value >= this.total)) {
                boolean bl2 = false;
                String string = "Total can not decrement! (current=" + this.total + ", wanted=" + value + ')';
                throw new IllegalStateException(string.toString());
            }
            this.total = value;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChild(@NotNull CountUpAndDownLatch latch) {
        Intrinsics.checkNotNullParameter((Object)latch, (String)"latch");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            latch.setParent(this);
            ((Collection)this.children).add(latch);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void await(long timeout) {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                if (this.rawCount == 0) {
                    return;
                }
                this.getLock().wait(timeout);
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static /* synthetic */ void await$default(CountUpAndDownLatch countUpAndDownLatch, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        countUpAndDownLatch.await(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmName(name="customNotify")
    private final void customNotify(CountUpAndDownLatch countUpAndDownLatch) {
        Iterator iterator = this.lock;
        synchronized (iterator) {
            boolean $i$a$-synchronized-CountUpAndDownLatch$notify$22 = false;
            for (Function0<Unit> callback : this.changeCallbacks) {
                callback.invoke();
            }
            this.getLock().notifyAll();
            Unit $i$a$-synchronized-CountUpAndDownLatch$notify$22 = Unit.INSTANCE;
        }
        for (CountUpAndDownLatch child : CollectionUtil.INSTANCE.toSynchronizedList((Collection)this.children)) {
            if (child == countUpAndDownLatch) continue;
            child.customNotify(this);
        }
        if (countUpAndDownLatch == this.parent) {
            return;
        }
        CountUpAndDownLatch countUpAndDownLatch2 = this.parent;
        if (countUpAndDownLatch2 != null) {
            countUpAndDownLatch2.customNotify(this);
        }
    }

    static /* synthetic */ void customNotify$default(CountUpAndDownLatch countUpAndDownLatch, CountUpAndDownLatch countUpAndDownLatch2, int n, Object object) {
        if ((n & 1) != 0) {
            countUpAndDownLatch2 = countUpAndDownLatch;
        }
        countUpAndDownLatch.customNotify(countUpAndDownLatch2);
    }

    @NotNull
    public final CountUpAndDownLatch inc() {
        this.plus(1);
        return this;
    }

    @NotNull
    public final CountUpAndDownLatch dec() {
        this.minus(1);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CountUpAndDownLatch plus(int value) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.setRawCount(this.rawCount + value);
            Unit unit = Unit.INSTANCE;
        }
        CountUpAndDownLatch countUpAndDownLatch = this.parent;
        CountUpAndDownLatch countUpAndDownLatch2 = countUpAndDownLatch == null ? null : countUpAndDownLatch.plus(value);
        if (countUpAndDownLatch2 == null) {
            CountUpAndDownLatch.customNotify$default(this, null, 1, null);
            countUpAndDownLatch2 = Unit.INSTANCE;
        }
        return this;
    }

    @NotNull
    public final CountUpAndDownLatch minus(int value) {
        return this.plus(-value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForChange() {
        int lastCount = this.getCount();
        int lastTotal = this.getTotal();
        while (lastCount == this.getCount() && lastTotal == this.getTotal()) {
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                this.getLock().wait();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void awaitWithChange() {
        if (this.getTotal() == 0) {
            this.waitForChange();
        }
        CountUpAndDownLatch.await$default(this, 0L, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void plusAssign(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ((Collection)this.changeCallbacks).add(callback);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public String toString() {
        String string = "%d / %d";
        Object[] objectArray = new Object[]{this.getCount(), this.getTotal()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @JvmOverloads
    public CountUpAndDownLatch(int count) {
        this(count, null, 2, null);
    }

    @JvmOverloads
    public final void await() {
        CountUpAndDownLatch.await$default(this, 0L, 1, null);
    }
}

