/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.math;

import de.bixilon.kutil.primitive.BooleanUtil;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tJ\u001e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\nR\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0015\u0010\r\u001a\u00020\u0006*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0011\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0015\u0010\u0011\u001a\u00020\t*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006 "}, d2={"Lde/bixilon/kutil/math/MMath;", "", "()V", "LN_2", "", "ceil", "", "getCeil", "(D)I", "", "(F)I", "floor", "getFloor", "positiveNegative", "", "getPositiveNegative", "(Z)I", "round10", "getRound10", "(D)D", "(F)F", "ceilLog2", "value", "clamp", "min", "max", "divideUp", "divider", "fractionalPart", "round10Up", "square", "d", "kutil"})
public final class MMath {
    @NotNull
    public static final MMath INSTANCE = new MMath();
    private static final double LN_2 = 0.6931471805599453;

    private MMath() {
    }

    public final int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public final float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public final double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public final int divideUp(int value, int divider) {
        return (value + divider - 1) / divider;
    }

    public final float divideUp(float value, float divider) {
        return (value + divider - 1.0f) / divider;
    }

    public final int round10(float value) {
        return ((int)(value * (float)10) + 5) / 10;
    }

    public final float getRound10(float $this$round10) {
        return (float)((int)($this$round10 * (float)10)) / 10.0f;
    }

    public final double getRound10(double $this$round10) {
        return (double)((int)($this$round10 * (double)10)) / 10.0;
    }

    public final int round10Up(float value) {
        int intValue = (int)value;
        float rest = value / (float)intValue;
        if (rest > 0.0f) {
            return intValue + 1;
        }
        return intValue;
    }

    public final double square(double d) {
        return d * d;
    }

    public final double fractionalPart(double value) {
        return value - Math.floor(value);
    }

    public final int getPositiveNegative(boolean $this$positiveNegative) {
        return $this$positiveNegative ? 1 : -1;
    }

    public final int getFloor(double $this$floor) {
        int n = (int)$this$floor;
        return ((Number)BooleanUtil.INSTANCE.decide($this$floor < (double)n, Integer.valueOf(n - 1), Integer.valueOf(n))).intValue();
    }

    public final int getFloor(float $this$floor) {
        int n = (int)$this$floor;
        return ((Number)BooleanUtil.INSTANCE.decide($this$floor < (float)n, Integer.valueOf(n - 1), Integer.valueOf(n))).intValue();
    }

    public final int getCeil(double $this$ceil) {
        int n = (int)$this$ceil;
        return ((Number)BooleanUtil.INSTANCE.decide($this$ceil > (double)n, Integer.valueOf(n + 1), Integer.valueOf(n))).intValue();
    }

    public final int getCeil(float $this$ceil) {
        int n = (int)$this$ceil;
        return ((Number)BooleanUtil.INSTANCE.decide($this$ceil > (float)n, Integer.valueOf(n + 1), Integer.valueOf(n))).intValue();
    }

    public final int ceilLog2(int value) {
        return (int)Math.ceil(Math.log(value) / 0.6931471805599453);
    }
}

