/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.watcher.map;

import de.bixilon.kutil.cast.CastUtil;
import de.bixilon.kutil.watcher.map.MapChange;
import de.bixilon.kutil.watcher.map.MapEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J&\u0010\u001f\u001a\u00020\u001e2\u001e\u0010 \u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001cJ\b\u0010!\u001a\u00020\u001eH\u0016J\u0015\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0015\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020#H\u0016J\u001f\u0010+\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010,J\u001e\u0010-\u001a\u00020\u001e2\u0014\u0010.\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010/H\u0016J\u0017\u00100\u001a\u0004\u0018\u00018\u00012\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)R-\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f*\u0004\b\t\u0010\nR!\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\f*\u0004\b\u000e\u0010\nR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014*\u0004\b\u0012\u0010\nR!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019*\u0004\b\u0017\u0010\nR,\u0010\u001a\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/bixilon/kutil/watcher/map/ObservedMap;", "K", "V", "", "original", "(Ljava/util/Map;)V", "entries", "", "", "getEntries$delegate", "(Lde/bixilon/kutil/watcher/map/ObservedMap;)Ljava/lang/Object;", "getEntries", "()Ljava/util/Set;", "keys", "getKeys$delegate", "getKeys", "size", "", "getSize$delegate", "getSize", "()I", "values", "", "getValues$delegate", "getValues", "()Ljava/util/Collection;", "watchers", "", "Lkotlin/Function1;", "Lde/bixilon/kutil/watcher/map/MapChange;", "", "addWatcher", "watcher", "clear", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "kutil"})
public final class ObservedMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    private final Map<K, V> original;
    @NotNull
    private final List<Function1<MapChange<K, V>, Unit>> watchers;

    public ObservedMap(@NotNull Map<K, V> original) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        this.original = original;
        this.watchers = new ArrayList();
    }

    public int getSize() {
        return this.original.size();
    }

    public static Object getSize$delegate(ObservedMap<Object, Object> observedMap) {
        Intrinsics.checkNotNullParameter(observedMap, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedMap.original, Map.class, "size", "size()I", 0)));
    }

    public final void addWatcher(@NotNull Function1<? super MapChange<K, V>, Unit> watcher) {
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        ((Collection)this.watchers).add(watcher);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.original.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.original.containsValue(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.original.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return this.original.entrySet();
    }

    public static Object getEntries$delegate(ObservedMap<Object, Object> observedMap) {
        Intrinsics.checkNotNullParameter(observedMap, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedMap.original, Map.class, "entries", "entrySet()Ljava/util/Set;", 0)));
    }

    @NotNull
    public Set<K> getKeys() {
        return this.original.keySet();
    }

    public static Object getKeys$delegate(ObservedMap<Object, Object> observedMap) {
        Intrinsics.checkNotNullParameter(observedMap, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedMap.original, Map.class, "keys", "keySet()Ljava/util/Set;", 0)));
    }

    @NotNull
    public Collection<V> getValues() {
        return this.original.values();
    }

    public static Object getValues$delegate(ObservedMap<Object, Object> observedMap) {
        Intrinsics.checkNotNullParameter(observedMap, (String)"<this>");
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl(observedMap.original, Map.class, "values", "values()Ljava/util/Collection;", 0)));
    }

    @Override
    public void clear() {
        MapChange<K, V> change = new MapChange<K, V>(SetsKt.emptySet(), this.entrySet());
        for (Function1<MapChange<K, V>, Unit> watcher : this.watchers) {
            watcher.invoke(change);
        }
        this.original.clear();
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Set set;
        V original;
        V v = original = this.original.put(key, value);
        if (v == null) {
            set = null;
        } else {
            V it = v;
            boolean bl = false;
            set = SetsKt.setOf(new MapEntry<K, V>(key, it));
        }
        Set set2 = set;
        Set removed = set2 == null ? SetsKt.emptySet() : set2;
        MapChange change = new MapChange(SetsKt.setOf(new MapEntry<K, V>(key, value)), removed);
        for (Function1<MapChange<K, V>, Unit> watcher : this.watchers) {
            watcher.invoke(change);
        }
        return original;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        Set removed = new LinkedHashSet();
        for (Map.Entry<K, V> object : from.entrySet()) {
            V v;
            K k;
            K k2 = object.getKey();
            V value = object.getValue();
            Collection collection = removed;
            if (this.original.put(k2, value) == null) continue;
            MapEntry<K, V> mapEntry = new MapEntry<K, V>(k, v);
            collection.add(mapEntry);
        }
        MapChange<K, V> change = new MapChange<K, V>(from.entrySet(), removed);
        for (Function1<MapChange<K, V>, Unit> function1 : this.watchers) {
            function1.invoke(change);
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V v = this.original.remove(key);
        if (v == null) {
            return null;
        }
        V removed = v;
        MapChange change = new MapChange(SetsKt.emptySet(), SetsKt.setOf(new MapEntry<Object, V>(key, removed)));
        for (Function1<MapChange<K, V>, Unit> watcher : this.watchers) {
            watcher.invoke(CastUtil.INSTANCE.unsafeCast(change));
        }
        return removed;
    }
}

