/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.array;

import de.bixilon.kutil.cast.CastUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t*\n\u0012\u0006\u0012\u0004\u0018\u0001H\t0\bH\u0086\b\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\bH\u0086\b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\r\u001a\u0002H\t\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\bH\u0086\b\u00a2\u0006\u0002\u0010\fJ(\u0010\u000e\u001a\u0004\u0018\u00010\u0004\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\b2\u0006\u0010\u0005\u001a\u0002H\tH\u0086\b\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\t*\n\u0012\u0006\u0012\u0004\u0018\u0001H\t0\b\u00a2\u0006\u0002\u0010\u0012J&\u0010\u0013\u001a\u00020\u0011\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0014J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0006\b\u0000\u0010\t\u0018\u0001*\n\u0012\u0006\u0012\u0004\u0018\u0001H\t0\bH\u0086\b\u00a2\u0006\u0002\u0010\nJ.\u0010\u0016\u001a\u00020\u0011\"\u0004\b\u0000\u0010\t*\b\u0012\u0004\u0012\u0002H\t0\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u0002H\tH\u0086\b\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lde/bixilon/kutil/array/ArrayUtil;", "", "()V", "modifyArrayIndex", "", "value", "size", "cast", "", "T", "([Ljava/lang/Object;)[Ljava/lang/Object;", "getFirst", "([Ljava/lang/Object;)Ljava/lang/Object;", "getLast", "index", "([Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Integer;", "isEmptyOrOnlyNull", "", "([Ljava/lang/Object;)Z", "isIndex", "([Ljava/lang/Object;I)Z", "trim", "trySet", "([Ljava/lang/Object;ILjava/lang/Object;)Z", "kutil"})
public final class ArrayUtil {
    @NotNull
    public static final ArrayUtil INSTANCE = new ArrayUtil();

    private ArrayUtil() {
    }

    @Nullable
    public final <T> Integer index(@NotNull T[] $this$index, T value) {
        Intrinsics.checkNotNullParameter($this$index, (String)"<this>");
        boolean $i$f$index = false;
        int index = ArraysKt.indexOf((Object[])$this$index, value);
        if (index < 0) {
            return null;
        }
        return index;
    }

    public final int modifyArrayIndex(int value, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be > 1: " + size);
        }
        int ret = value % size;
        if (ret < 0) {
            ret += size;
        }
        return ret;
    }

    @NotNull
    public final <T> T[] cast(@NotNull T[] $this$cast) {
        Intrinsics.checkNotNullParameter($this$cast, (String)"<this>");
        boolean $i$f$cast = false;
        CastUtil castUtil = CastUtil.INSTANCE;
        T[] $this$unsafeCast$iv = $this$cast;
        boolean $i$f$unsafeCast = false;
        return (Object[])((Object)$this$unsafeCast$iv);
    }

    public final <T> boolean isIndex(@NotNull T[] $this$isIndex, int index) {
        Intrinsics.checkNotNullParameter($this$isIndex, (String)"<this>");
        boolean $i$f$isIndex = false;
        return index > 0 && index < $this$isIndex.length;
    }

    public final <T> boolean trySet(@NotNull T[] $this$trySet, int index, T value) {
        Intrinsics.checkNotNullParameter($this$trySet, (String)"<this>");
        boolean $i$f$trySet = false;
        if (index < 0 || index >= $this$trySet.length) {
            return false;
        }
        $this$trySet[index] = value;
        return true;
    }

    public final <T> boolean isEmptyOrOnlyNull(@NotNull T[] $this$isEmptyOrOnlyNull) {
        Intrinsics.checkNotNullParameter($this$isEmptyOrOnlyNull, (String)"<this>");
        for (T entry : $this$isEmptyOrOnlyNull) {
            if (entry == null) continue;
            return false;
        }
        return true;
    }

    public final <T> T getFirst(@NotNull T[] $this$getFirst) {
        Intrinsics.checkNotNullParameter($this$getFirst, (String)"<this>");
        boolean $i$f$getFirst = false;
        return $this$getFirst[0];
    }

    public final <T> T getLast(@NotNull T[] $this$getLast) {
        Intrinsics.checkNotNullParameter($this$getLast, (String)"<this>");
        boolean $i$f$getLast = false;
        return $this$getLast[ArraysKt.getLastIndex((Object[])$this$getLast)];
    }

    public final /* synthetic */ <T> T[] trim(T[] $this$trim) {
        Intrinsics.checkNotNullParameter($this$trim, (String)"<this>");
        boolean $i$f$trim = false;
        List list = new ArrayList();
        for (T entry : $this$trim) {
            if (entry == null) continue;
            ((Collection)list).add(entry);
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return thisCollection$iv.toArray(new Object[0]);
    }
}

