/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.buffer.bytes.out;

import de.bixilon.kutil.collections.primitive.bytes.HeapArrayByteList;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ3\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0002\u0010\u0010J.\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00122\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u000fJ\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\"J\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(J\u000e\u0010&\u001a\u00020\n2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\n2\u0006\u0010'\u001a\u00020(J\u000e\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00020(J\u000e\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00020*J\u000e\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020\"J\u000e\u0010/\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0016J\u000e\u00100\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020$J\u000e\u00101\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0018J/\u00102\u001a\u00020\n\"\u0004\b\u0000\u0010\u000b2\b\u0010\u001d\u001a\u0004\u0018\u0001H\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\n0\u000f\u00a2\u0006\u0002\u00103J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\"J\u000e\u00104\u001a\u00020\n2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u00108\u001a\u00020\n2\u0006\u0010\u0002\u001a\u000209J\u000e\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\n2\u0006\u0010.\u001a\u00020\"J\u000e\u0010>\u001a\u00020\n2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lde/bixilon/kutil/buffer/bytes/out/OutByteBuffer;", "", "buffer", "(Lde/bixilon/kutil/buffer/bytes/out/OutByteBuffer;)V", "()V", "bytes", "Lde/bixilon/kutil/collections/primitive/bytes/HeapArrayByteList;", "toArray", "", "writeArray", "", "T", "array", "", "writer", "Lkotlin/Function1;", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "collection", "", "writeBareByteArray", "data", "writeBareIntArray", "", "writeBareLongArray", "", "writeBareString", "string", "", "writeBoolean", "value", "", "writeByte", "byte", "", "", "long", "", "writeByteArray", "writeDouble", "double", "", "float", "", "writeFixedPointNumberInt", "writeFloat", "writeInt", "int", "writeIntArray", "writeLong", "writeLongArray", "writeOptional", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "writeShort", "short", "", "writeString", "writeTo", "Ljava/nio/ByteBuffer;", "writeUUID", "uuid", "Ljava/util/UUID;", "writeVarInt", "writeVarLong", "kutil"})
public class OutByteBuffer {
    @NotNull
    private final HeapArrayByteList bytes;

    public OutByteBuffer() {
        this.bytes = new HeapArrayByteList(0, 1, null);
    }

    public OutByteBuffer(@NotNull OutByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this();
        this.bytes.addAll(buffer.bytes);
    }

    public final void writeShort(short s) {
        this.writeShort((int)s);
    }

    public final void writeShort(int n) {
        this.writeByte(n >>> 8);
        this.writeByte(n);
    }

    public final void writeInt(int n) {
        this.writeShort(n >> 16);
        this.writeShort(n);
    }

    public void writeBareByteArray(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.bytes.addAll(data);
    }

    public void writeByteArray(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.writeVarInt(data.length);
        this.bytes.addAll(data);
    }

    public final void writeLong(long value) {
        this.writeInt((int)(value >> 32));
        this.writeInt((int)value);
    }

    public final void writeString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        this.writeVarInt(bytes.length);
        this.writeBareByteArray(bytes);
    }

    public final void writeVarLong(long l) {
        long value = l;
        do {
            long temp = value & 0x7FL;
            if ((value >>>= 7) != 0L) {
                temp |= 0x80L;
            }
            this.writeByte(temp);
        } while (value != 0L);
    }

    public final void writeByte(byte by) {
        this.bytes.add(by);
    }

    public final void writeByte(int n) {
        this.writeByte((byte)(n & 0xFF));
    }

    public final void writeByte(long l) {
        this.writeByte((byte)(l & 0xFFL));
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeFloat(double d) {
        this.writeFloat((float)d);
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeDouble(float f) {
        this.writeDouble((double)f);
    }

    public final void writeUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    public final void writeFixedPointNumberInt(double d) {
        this.writeInt((int)(d * 32.0));
    }

    public final void writeVarInt(int n) {
        int value = n;
        do {
            int temp = value & 0x7F;
            if ((value >>>= 7) != 0) {
                temp |= 0x80;
            }
            this.writeByte(temp);
        } while (value != 0);
    }

    public final void writeBoolean(boolean value) {
        this.writeByte(value ? 1 : 0);
    }

    public final void writeBareString(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String string2 = string;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.writeBareByteArray(byArray);
    }

    @NotNull
    public final byte[] toArray() {
        return this.bytes.toArray();
    }

    public final void writeBareIntArray(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (int i : data) {
            this.writeInt(i);
        }
    }

    public final void writeIntArray(@NotNull int[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.writeVarInt(data.length);
        this.writeBareIntArray(data);
    }

    public final void writeBareLongArray(@NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        for (long l : data) {
            this.writeLong(l);
        }
    }

    public final void writeLongArray(@NotNull long[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.writeVarInt(data.length);
        this.writeBareLongArray(data);
    }

    public final void writeTo(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.put(this.toArray());
    }

    public final <T> void writeArray(@NotNull T[] array, @NotNull Function1<? super T, Unit> writer) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.writeVarInt(array.length);
        for (T entry : array) {
            writer.invoke(entry);
        }
    }

    public final <T> void writeArray(@NotNull Collection<? extends T> collection, @NotNull Function1<? super T, Unit> writer) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.writeVarInt(collection.size());
        for (T entry : collection) {
            writer.invoke(entry);
        }
    }

    public final <T> void writeOptional(@Nullable T value, @NotNull Function1<? super T, Unit> writer) {
        block0: {
            Intrinsics.checkNotNullParameter(writer, (String)"writer");
            this.writeBoolean(value != null);
            T t = value;
            if (t == null) break block0;
            writer.invoke(t);
        }
    }
}

