/*
 * Decompiled with CFR 0.152.
 */
package de.bixilon.kutil.collections.primitive.bytes;

import de.bixilon.kutil.collections.primitive.bytes.AbstractByteList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\r\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0001H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u0004\u00a8\u0006#"}, d2={"Lde/bixilon/kutil/collections/primitive/bytes/HeapArrayByteList;", "Lde/bixilon/kutil/collections/primitive/bytes/AbstractByteList;", "initialSize", "", "(I)V", "data", "", "isEmpty", "", "()Z", "limit", "getLimit", "()I", "nextGrowStep", "output", "outputUpToDate", "size", "getSize", "setSize", "add", "", "value", "", "addAll", "byteList", "bytes", "checkFinalized", "checkOutputArray", "clear", "ensureSize", "needed", "finish", "grow", "toArray", "Companion", "kutil"})
public final class HeapArrayByteList
extends AbstractByteList {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] data;
    private int size;
    private final int nextGrowStep;
    @NotNull
    private byte[] output;
    private boolean outputUpToDate;
    @Deprecated
    private static final int DEFAULT_INITIAL_SIZE = 1000;

    public HeapArrayByteList(int initialSize) {
        this.data = new byte[initialSize];
        this.nextGrowStep = initialSize <= 0 ? 1000 : (initialSize <= 50 ? 50 : initialSize);
        this.output = new byte[0];
    }

    public /* synthetic */ HeapArrayByteList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1000;
        }
        this(n);
    }

    @Override
    public int getLimit() {
        return this.data.length;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    private final void checkFinalized() {
        if (this.getFinished()) {
            throw new IllegalStateException("ByteArrayList is already finalized!");
        }
    }

    @Override
    public void clear() {
        this.checkFinalized();
        this.setSize(0);
        this.outputUpToDate = false;
        this.output = new byte[0];
    }

    @Override
    public void ensureSize(int needed) {
        this.checkFinalized();
        if (this.getLimit() - this.getSize() >= needed) {
            return;
        }
        int newSize = this.data.length;
        while (newSize - this.getSize() < needed) {
            newSize += this.nextGrowStep;
        }
        this.grow(newSize);
    }

    private final void grow(int size) {
        byte[] oldData = this.data;
        this.data = new byte[size];
        System.arraycopy(oldData, 0, this.data, 0, oldData.length);
    }

    @Override
    public void add(byte value) {
        this.ensureSize(1);
        int n = this.getSize();
        this.setSize(n + 1);
        this.data[n] = value;
        if (this.outputUpToDate) {
            this.outputUpToDate = false;
        }
    }

    @Override
    public void addAll(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.ensureSize(bytes.length);
        System.arraycopy(bytes, 0, this.data, this.getSize(), bytes.length);
        this.setSize(this.getSize() + bytes.length);
        if (this.outputUpToDate) {
            this.outputUpToDate = false;
        }
    }

    @Override
    public void addAll(@NotNull AbstractByteList byteList) {
        Intrinsics.checkNotNullParameter((Object)byteList, (String)"byteList");
        this.ensureSize(byteList.getSize());
        byte[] source = byteList instanceof HeapArrayByteList ? (byteList.getFinished() ? ((HeapArrayByteList)byteList).output : ((HeapArrayByteList)byteList).data) : byteList.toArray();
        System.arraycopy(source, 0, this.data, this.getSize(), byteList.getSize());
        this.setSize(this.getSize() + byteList.getSize());
        if (this.outputUpToDate) {
            this.outputUpToDate = false;
        }
    }

    private final void checkOutputArray() {
        if (this.outputUpToDate) {
            return;
        }
        this.output = new byte[this.getSize()];
        System.arraycopy(this.data, 0, this.output, 0, this.getSize());
        this.outputUpToDate = true;
    }

    @Override
    @NotNull
    public byte[] toArray() {
        this.checkOutputArray();
        return this.output;
    }

    @Override
    public void finish() {
        this.setFinished(true);
        this.checkOutputArray();
        this.data = new byte[0];
    }

    public HeapArrayByteList() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/bixilon/kutil/collections/primitive/bytes/HeapArrayByteList$Companion;", "", "()V", "DEFAULT_INITIAL_SIZE", "", "kutil"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

